/*
 * Decompiled with CFR 0.152.
 */
package io.github.kylinhunter.commons.component;

import io.github.kylinhunter.commons.component.CMethod;
import io.github.kylinhunter.commons.component.CMethodManager;
import io.github.kylinhunter.commons.component.CompManager;
import io.github.kylinhunter.commons.exception.embed.InitException;
import io.github.kylinhunter.commons.reflect.GenericTypeUtils;
import io.github.kylinhunter.commons.reflect.ObjectCreator;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;
import lombok.Generated;

class MethodCompManager {
    private CompManager compManager;
    protected CMethodManager methodManager;

    public MethodCompManager(CompManager compManager) {
        this.compManager = compManager;
        this.methodManager = new CMethodManager(compManager);
    }

    public void calculate() {
        this.methodManager.calculate();
        List<CMethod> methods = this.methodManager.getCmethods();
        for (CMethod method : methods) {
            this.calculate(method);
        }
        this.compManager.check(this.methodManager.getCompClasses());
    }

    public void calculate(CMethod cmethod) {
        Method method = cmethod.getMethod();
        Object object = cmethod.getCompObject();
        int parameterCount = method.getParameterCount();
        Class<?> compClazz = method.getReturnType();
        if (parameterCount <= 0) {
            this.compManager.register(compClazz, cmethod, ObjectCreator.create(object, method, new Object[0]));
        } else {
            Class<?>[] parameterTypes = method.getParameterTypes();
            Type[] genericParameterTypes = method.getGenericParameterTypes();
            Object[] parameterObj = new Object[parameterCount];
            for (int i = 0; i < parameterCount; ++i) {
                Type type;
                Class argClass;
                List comps;
                Class<?> curParametorClass = parameterTypes[i];
                Object obj = this.compManager.get(curParametorClass, false);
                if (obj != null) {
                    parameterObj[i] = obj;
                } else if (List.class.isAssignableFrom(curParametorClass) && (comps = this.compManager.getAll(argClass = GenericTypeUtils.getActualTypeArgument(type = genericParameterTypes[i], 0), false)).size() > 0) {
                    parameterObj[i] = comps;
                }
                if (parameterObj[i] != null) continue;
                throw new InitException("no component:" + compClazz.getName());
            }
            this.compManager.register(compClazz, cmethod, ObjectCreator.create(object, method, parameterObj));
        }
    }

    @Generated
    public MethodCompManager() {
    }
}

