/*
 * Decompiled with CFR 0.152.
 */
package io.github.kylinhunter.commons.date;

import io.github.kylinhunter.commons.exception.embed.ParamException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import lombok.Generated;

public class DateFormat {
    private String pattern;
    private DateTimeFormatter dateTimeFormatter;
    private boolean parseByLocalDate;

    DateFormat(String pattern) {
        this.pattern = pattern;
        this.dateTimeFormatter = pattern.equals("yyyyMMddHHmmssSSS") ? new DateTimeFormatterBuilder().appendPattern("yyyyMMddHHmmss").appendValue(ChronoField.MILLI_OF_SECOND, 3).toFormatter() : DateTimeFormatter.ofPattern(pattern);
        this.parseByLocalDate = pattern.equals("yyyy-MM-dd") || pattern.equals("yyyy/MM/dd") || pattern.equals("yyyyMMdd");
    }

    public String format(TemporalAccessor temporal) {
        try {
            return this.dateTimeFormatter.format(temporal);
        }
        catch (Exception e) {
            throw new ParamException("format error:" + temporal, (Throwable)e);
        }
    }

    public LocalDateTime parse(CharSequence text) {
        try {
            if (this.parseByLocalDate) {
                return LocalDate.parse(text, this.dateTimeFormatter).atStartOfDay();
            }
            return LocalDateTime.parse(text, this.dateTimeFormatter);
        }
        catch (Exception e) {
            throw new ParamException("parse error:" + text, (Throwable)e);
        }
    }

    @Generated
    public String getPattern() {
        return this.pattern;
    }

    @Generated
    public DateTimeFormatter getDateTimeFormatter() {
        return this.dateTimeFormatter;
    }

    @Generated
    public boolean isParseByLocalDate() {
        return this.parseByLocalDate;
    }

    @Generated
    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    @Generated
    public void setDateTimeFormatter(DateTimeFormatter dateTimeFormatter) {
        this.dateTimeFormatter = dateTimeFormatter;
    }

    @Generated
    public void setParseByLocalDate(boolean parseByLocalDate) {
        this.parseByLocalDate = parseByLocalDate;
    }
}

