/*
 * Decompiled with CFR 0.152.
 */
package io.github.kylinhunter.commons.date;

import io.github.kylinhunter.commons.date.DateFormat;
import io.github.kylinhunter.commons.date.DateFormats;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Date;

public class DateUtils {
    static ZoneOffset zoneOffset = ZoneOffset.ofHours(8);

    public static String format(LocalDateTime localDateTime, DateFormat format) {
        return format.format(localDateTime);
    }

    public static String format(LocalDateTime localDateTime) {
        return DateUtils.format(localDateTime, DateFormats.DATE_TIME);
    }

    public static String format(long timestamp) {
        return DateUtils.format(DateUtils.toLocalDateTime(timestamp));
    }

    public static String formatNow() {
        return DateUtils.format(LocalDateTime.now(), DateFormats.DATE_TIME);
    }

    public static String formatWithDate(LocalDateTime localDateTime) {
        return DateUtils.format(localDateTime, DateFormats.DATE);
    }

    public static String formatNowWithDate() {
        return DateUtils.format(LocalDateTime.now(), DateFormats.DATE);
    }

    public static LocalDateTime parse(String date, DateFormat format) {
        return format.parse(date);
    }

    public static LocalDateTime parse(String date) {
        return DateUtils.parse(date, DateFormats.DATE_TIME);
    }

    public static LocalDateTime parseWithDate(String date) {
        return DateUtils.parse(date, DateFormats.DATE);
    }

    public static long toMilli(LocalDateTime localDateTime, ZoneOffset zoneOffset) {
        return localDateTime.toInstant(zoneOffset).toEpochMilli();
    }

    public static long toMilli(LocalDateTime localDateTime) {
        return localDateTime.toInstant(zoneOffset).toEpochMilli();
    }

    public static LocalDateTime toLocalDateTime(long date, ZoneOffset zoneOffset) {
        return new Date(date).toInstant().atOffset(zoneOffset).toLocalDateTime();
    }

    public static LocalDateTime toLocalDateTime(long date) {
        return Instant.ofEpochMilli(date).atOffset(zoneOffset).toLocalDateTime();
    }

    public static LocalDateTime toLocalDateTime(Date date, ZoneOffset zoneOffset) {
        return date.toInstant().atOffset(zoneOffset).toLocalDateTime();
    }

    public static LocalDateTime toLocalDateTime(Date date) {
        return date.toInstant().atOffset(zoneOffset).toLocalDateTime();
    }

    public static Date toDate(LocalDateTime localDateTime, ZoneOffset zoneOffset) {
        return Date.from(localDateTime.atZone(zoneOffset).toInstant());
    }

    public static Date toDate(LocalDateTime localDateTime) {
        return Date.from(localDateTime.atZone(zoneOffset).toInstant());
    }
}

