/*
 * Decompiled with CFR 0.152.
 */
package io.github.kylinhunter.commons.exception;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.github.kylinhunter.commons.exception.common.KRuntimeException;
import io.github.kylinhunter.commons.exception.explain.ExplainManager;
import io.github.kylinhunter.commons.exception.explain.ExplainResult;
import io.github.kylinhunter.commons.exception.info.ErrInfos;
import java.util.logging.Logger;

public class ExceptionConvertor {
    private static Logger logger = Logger.getLogger(ExceptionConvertor.class.toString());

    public static KRuntimeException convert(Throwable exception) {
        return ExceptionConvertor.convert(exception, true);
    }

    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"})
    public static KRuntimeException convert(Throwable exception, boolean withCause) {
        try {
            if (KRuntimeException.class.isAssignableFrom(exception.getClass())) {
                return (KRuntimeException)exception;
            }
            ExplainResult explainResult = ExplainManager.explain(exception);
            if (withCause) {
                return new KRuntimeException(explainResult.getErrInfo(), explainResult.getExtra(), explainResult.getMsg(), exception);
            }
            return new KRuntimeException(explainResult.getErrInfo(), explainResult.getExtra(), explainResult.getMsg());
        }
        catch (Exception e) {
            logger.warning("convert error" + e.getMessage());
            return new KRuntimeException(ErrInfos.UNKNOWN, exception.getMessage());
        }
    }
}

