/*
 * Decompiled with CFR 0.152.
 */
package io.github.kylinhunter.commons.exception;

import java.util.Set;
import lombok.Generated;

public class ExceptionFinder {
    public static <T extends Throwable> T find(Throwable throwable, boolean acceptSubClass, Class<T> cls) {
        if (cls != null) {
            while (throwable != null) {
                if (throwable.getClass().equals(cls)) {
                    return (T)throwable;
                }
                if (acceptSubClass && cls.isAssignableFrom(throwable.getClass())) {
                    return (T)throwable;
                }
                throwable = throwable.getCause();
            }
        }
        return null;
    }

    public static ExceptionFind find(Throwable throwable, boolean acceptSubClass, Set<Class<? extends Throwable>> samples) {
        if (samples != null) {
            while (throwable != null) {
                for (Class<? extends Throwable> sample : samples) {
                    if (throwable.getClass().equals(sample)) {
                        return new ExceptionFind(throwable, sample);
                    }
                    if (!acceptSubClass || !sample.isAssignableFrom(throwable.getClass())) continue;
                    return new ExceptionFind(throwable, sample);
                }
                throwable = throwable.getCause();
            }
        }
        return null;
    }

    public static class ExceptionFind {
        private final Throwable target;
        private final Class<? extends Throwable> source;

        @Generated
        public ExceptionFind(Throwable target, Class<? extends Throwable> source) {
            this.target = target;
            this.source = source;
        }

        @Generated
        public Throwable getTarget() {
            return this.target;
        }

        @Generated
        public Class<? extends Throwable> getSource() {
            return this.source;
        }
    }
}

