/*
 * Decompiled with CFR 0.152.
 */
package io.github.kylinhunter.commons.exception;

import io.github.kylinhunter.commons.exception.common.KThrowable;
import io.github.kylinhunter.commons.exception.info.ErrInfo;
import io.github.kylinhunter.commons.exception.info.ErrInfos;
import io.github.kylinhunter.commons.lang.strings.StringUtil;

public class ExceptionHelper {
    public static int getErrCode(Throwable e) {
        ErrInfo errInfo;
        if (e instanceof KThrowable && (errInfo = ((KThrowable)((Object)e)).getErrInfo()) != null) {
            return errInfo.getCode();
        }
        return ErrInfos.UNKNOWN.getCode();
    }

    public static String getMessage(Throwable e) {
        return ExceptionHelper.getMessage(e, false, 100);
    }

    public static String getMessage(Throwable e, boolean debug, int max) {
        String message = null;
        if (e instanceof KThrowable) {
            ErrInfo errInfo = ((KThrowable)((Object)e)).getErrInfo();
            if (errInfo != null && errInfo != ErrInfos.UNKNOWN && StringUtil.isBlank(message = e.getMessage())) {
                message = errInfo.getDefaultMsg();
            }
        } else if (debug) {
            message = e.getMessage();
        }
        message = StringUtil.defaultString(message, ErrInfos.UNKNOWN.getDefaultMsg());
        return StringUtil.substring(message, 0, max);
    }
}

