/*
 * Decompiled with CFR 0.152.
 */
package io.github.kylinhunter.commons.exception.check;

import io.github.kylinhunter.commons.collections.ArrayUtils;
import io.github.kylinhunter.commons.collections.CollectionUtils;
import io.github.kylinhunter.commons.exception.embed.ParamException;
import io.github.kylinhunter.commons.lang.strings.StringUtil;
import java.util.Collection;

public class ThrowChecker {
    public static <T> T checkNotNull(T reference) {
        if (reference == null) {
            throw new ParamException("can't be null ");
        }
        return reference;
    }

    public static <T> T checkNotNull(T reference, String errorMessage) {
        if (reference == null) {
            throw new ParamException(errorMessage);
        }
        return reference;
    }

    public static void checkNotEmpty(Collection<?> collection, String errorMessage) {
        if (CollectionUtils.isEmpty(collection)) {
            throw new ParamException(errorMessage);
        }
    }

    public static void checkNotEmpty(Object[] array) {
        ThrowChecker.checkNotEmpty(array, "array can't be  empty");
    }

    public static void checkNotEmpty(Object[] array, String errorMessage) {
        if (ArrayUtils.isEmpty(array)) {
            throw new ParamException(errorMessage);
        }
    }

    public static void checkNotEmpty(String name, String errorMessage) {
        if (StringUtil.isEmpty(name)) {
            throw new ParamException(errorMessage);
        }
    }

    public static void checkArgument(boolean expression, String errorMessage) {
        if (!expression) {
            throw new ParamException(String.valueOf(errorMessage));
        }
    }

    public static void checkNonnegative(int value, String name) {
        if (value < 0) {
            throw new ParamException(name + " cannot be negative but was: " + value);
        }
    }

    public static void checkNum(int value, int start, int end) {
        if (value < start || value >= end) {
            throw new ParamException(value + " not in [" + start + "," + end + ")");
        }
    }
}

