/*
 * Decompiled with CFR 0.152.
 */
package io.github.kylinhunter.commons.exception.explain;

import io.github.kylinhunter.commons.exception.embed.InitException;
import io.github.kylinhunter.commons.exception.explain.ExplainManager;
import io.github.kylinhunter.commons.exception.explain.ExplainerSupplier;
import io.github.kylinhunter.commons.exception.explain.Explainers;
import io.github.kylinhunter.commons.init.AbstractInitializer;
import io.github.kylinhunter.commons.init.ClassScanner;
import io.github.kylinhunter.commons.reflect.ObjectCreator;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Set;

public class ExplainerInitializer
extends AbstractInitializer {
    public ExplainerInitializer(Set<String> pkgs) {
        super(pkgs);
    }

    public ExplainerInitializer(ClassScanner classScanner) {
        super(classScanner);
    }

    @Override
    public void init() throws InitException {
        Set<Class<ExplainerSupplier>> classes = this.classScanner.getSubTypesOf(ExplainerSupplier.class);
        Explainers explainers = ExplainManager.getExplainers();
        for (Class<ExplainerSupplier> clazz : classes) {
            try {
                if (Modifier.isAbstract(clazz.getModifiers())) continue;
                explainers.add((List)ObjectCreator.create(clazz).get());
            }
            catch (Exception e) {
                throw new InitException("init  explainer error " + clazz.getName(), (Throwable)e);
            }
        }
    }
}

