/*
 * Decompiled with CFR 0.152.
 */
package io.github.kylinhunter.commons.exception.explain;

import io.github.kylinhunter.commons.collections.MapUtils;
import io.github.kylinhunter.commons.collections.SetUtils;
import io.github.kylinhunter.commons.exception.ExceptionFinder;
import io.github.kylinhunter.commons.exception.common.KRuntimeException;
import io.github.kylinhunter.commons.exception.common.KThrowable;
import io.github.kylinhunter.commons.exception.explain.ExplainResult;
import io.github.kylinhunter.commons.exception.explain.Explainer;
import io.github.kylinhunter.commons.exception.info.ErrInfos;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Explainers {
    public final Map<Class<? extends Throwable>, Explainer> allExplainers = MapUtils.newHashMap();
    public final Set<Class<? extends Throwable>> allExceptions = SetUtils.newHashSet();

    public Explainer getExplain(Class<? extends Throwable> clazz) {
        return this.allExplainers.get(clazz);
    }

    public void add(List<Explainer> explainers) {
        explainers.forEach(explain -> {
            this.allExplainers.put((Class<? extends Throwable>)explain.getSource(), (Explainer)explain);
            this.allExceptions.add(explain.getSource());
        });
    }

    public ExplainResult explain(Throwable throwable) {
        ExplainResult result = new ExplainResult(ErrInfos.UNKNOWN, throwable.getMessage());
        if (throwable instanceof KThrowable) {
            result = new ExplainResult((KThrowable)((Object)throwable), throwable.getMessage());
        } else {
            KRuntimeException exception = ExceptionFinder.find(throwable, true, KRuntimeException.class);
            if (exception != null) {
                result = new ExplainResult(exception);
            } else {
                Explainer explainer;
                ExceptionFinder.ExceptionFind exceptionFind = ExceptionFinder.find(throwable, true, this.allExceptions);
                if (exceptionFind != null && (explainer = this.getExplain(exceptionFind.getSource())) != null) {
                    result = explainer.explain(exceptionFind.getTarget());
                }
            }
        }
        return result;
    }
}

