/*
 * Decompiled with CFR 0.152.
 */
package io.github.kylinhunter.commons.exception.info;

import io.github.kylinhunter.commons.exception.embed.InitException;
import io.github.kylinhunter.commons.exception.info.ErrInfo;
import io.github.kylinhunter.commons.exception.info.ErrInfoAware;
import io.github.kylinhunter.commons.exception.info.ErrInfoManager;
import io.github.kylinhunter.commons.init.AbstractInitializer;
import io.github.kylinhunter.commons.init.ClassScanner;
import io.github.kylinhunter.commons.init.Order;
import io.github.kylinhunter.commons.lang.strings.StringUtil;
import io.github.kylinhunter.commons.reflect.ReflectUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Set;
import java.util.function.Predicate;
import org.reflections.ReflectionUtils;

@Order(value=-2147483648)
public class ErrInfoInitializer
extends AbstractInitializer {
    public ErrInfoInitializer(Set<String> pkgs) {
        super(pkgs);
    }

    public ErrInfoInitializer(ClassScanner classScanner) {
        super(classScanner);
    }

    @Override
    public void init() throws InitException {
        Set<Class<?>> classes = this.classScanner.getTypesAnnotatedWith(ErrInfoAware.class);
        for (Class<?> clazz : classes) {
            Set allFields = ReflectionUtils.getAllFields(clazz, (Predicate[])new Predicate[0]);
            allFields.forEach(ErrInfoInitializer::processField);
        }
    }

    private static void processField(Field field) {
        int modifiers = field.getModifiers();
        if (field.getType() == ErrInfo.class && Modifier.isStatic(modifiers)) {
            ErrInfo errInfo = (ErrInfo)ReflectUtils.get(null, field);
            if (StringUtil.isEmpty(errInfo.getDefaultMsg())) {
                errInfo.setDefaultMsg(field.getName());
            }
            ErrInfoManager.add(errInfo);
        }
    }
}

