/*
 * Decompiled with CFR 0.152.
 */
package io.github.kylinhunter.commons.exception.info;

import io.github.kylinhunter.commons.collections.MapUtils;
import io.github.kylinhunter.commons.collections.SetUtils;
import io.github.kylinhunter.commons.exception.embed.InitException;
import io.github.kylinhunter.commons.exception.info.ErrInfo;
import io.github.kylinhunter.commons.exception.info.ErrInfoInitializer;
import io.github.kylinhunter.commons.exception.info.ErrInfos;
import java.util.Map;

public class ErrInfoManager {
    protected static final Map<Integer, ErrInfo> ERR_INFOS = MapUtils.newLinkedHashMap();

    public static void add(ErrInfo errInfo) {
        if (ERR_INFOS.containsKey(errInfo.getCode())) {
            throw new InitException(" error code is used:" + errInfo.getCode());
        }
        ERR_INFOS.put(errInfo.getCode(), errInfo);
    }

    public static String getDefaultMsg(int code) {
        return ERR_INFOS.getOrDefault(code, ErrInfos.UNKNOWN).getDefaultMsg();
    }

    public static void println() {
        System.out.println("print errInfo code\n ");
        ERR_INFOS.forEach((errCode, defaultMsg) -> System.out.println("erroCode=" + errCode + ",defaultMsg=" + defaultMsg));
    }

    static {
        new ErrInfoInitializer(SetUtils.newHashSet("io.github.kylinhunter")).initialize();
    }
}

