/*
 * Decompiled with CFR 0.152.
 */
package io.github.kylinhunter.commons.exception.wrapper;

import io.github.kylinhunter.commons.exception.common.KRuntimeException;
import io.github.kylinhunter.commons.exception.info.ErrInfo;
import io.github.kylinhunter.commons.exception.wrapper.ExceptionWrapper;
import io.github.kylinhunter.commons.lang.strings.StringUtil;
import io.github.kylinhunter.commons.sys.KGenerated;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import net.bytebuddy.implementation.bind.annotation.Origin;
import net.bytebuddy.implementation.bind.annotation.RuntimeType;
import net.bytebuddy.implementation.bind.annotation.SuperCall;

@KGenerated
public class ExceptionInvokeDelegation {
    private static final Logger log = Logger.getLogger(ExceptionInvokeDelegation.class.toString());

    @RuntimeType
    public static Object intercept(@Origin Method method, @SuperCall Callable<?> callable) throws Throwable {
        try {
            return callable.call();
        }
        catch (Throwable e) {
            Throwable thr = ExceptionInvokeDelegation.getNewException(method, e);
            if (thr != null) {
                throw thr;
            }
            throw e;
        }
    }

    private static Throwable getNewException(Method method, Throwable oriThrowable) {
        ExceptionWrapper annotation = method.getAnnotation(ExceptionWrapper.class);
        if (annotation != null) {
            Class<? extends Throwable> thr = annotation.value();
            try {
                if (KRuntimeException.class.isAssignableFrom(thr)) {
                    Constructor<? extends Throwable> constructor = thr.getConstructor(new Class[0]);
                    KRuntimeException throwable = (KRuntimeException)constructor.newInstance(new Object[0]);
                    String msg = annotation.msg();
                    msg = !StringUtil.isEmpty(msg) ? msg : oriThrowable.getMessage();
                    throwable.setErrInfo(new ErrInfo(annotation.code(), msg));
                    return throwable;
                }
            }
            catch (Exception e) {
                log.warning("Exception Invoke Delegation error:" + e.getMessage());
            }
            try {
                Constructor<? extends Throwable> constructor = thr.getConstructor(new Class[0]);
                Throwable throwable = constructor.newInstance(new Object[0]);
                throwable.initCause(oriThrowable);
                return throwable;
            }
            catch (Exception e) {
                log.warning("Exception Invoke Delegation error:" + e.getMessage());
            }
        }
        return oriThrowable;
    }
}

