/*
 * Decompiled with CFR 0.152.
 */
package io.github.kylinhunter.commons.i18n;

import io.github.kylinhunter.commons.collections.ArrayUtils;
import io.github.kylinhunter.commons.lang.strings.StringUtil;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import lombok.Generated;

public class I18nUtils {
    private static Locale currentLocale;
    private static ResourceBundle bundle;

    public static void init(String baseName, String language, String country) {
        bundle = ResourceBundle.getBundle(baseName, new Locale(language, country));
        currentLocale = bundle.getLocale();
    }

    public static void init(String language, String country) {
        I18nUtils.init("i18n/k-i18n", language, country);
    }

    public static String get(String key) {
        return I18nUtils.get(key, null);
    }

    public static String get(String key, Object[] param) {
        if (StringUtil.isEmpty(key)) {
            return "";
        }
        String value = bundle.getString(key);
        if (!ArrayUtils.isEmpty(param)) {
            return MessageFormat.format(value, param);
        }
        return value;
    }

    @Generated
    public static Locale getCurrentLocale() {
        return currentLocale;
    }
}

