/*
 * Decompiled with CFR 0.152.
 */
package io.github.kylinhunter.commons.init;

import io.github.kylinhunter.commons.collections.MapUtils;
import io.github.kylinhunter.commons.exception.embed.InitException;
import io.github.kylinhunter.commons.init.ClassScanner;
import io.github.kylinhunter.commons.init.DebugOption;
import io.github.kylinhunter.commons.init.Initializer;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractInitializer
implements Initializer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractInitializer.class);
    protected DebugOption debugOption;
    protected static volatile Map<Class<?>, Object> INITIALIZED_TAGS = MapUtils.newHashMap();
    protected ClassScanner classScanner;

    public AbstractInitializer(Set<String> pkgs) {
        this.classScanner = new ClassScanner(pkgs);
    }

    public AbstractInitializer(ClassScanner classScanner) {
        this.classScanner = classScanner;
    }

    @Override
    public synchronized void initialize() throws InitException {
        Object initializedObj = INITIALIZED_TAGS.get(this.getClass());
        if (initializedObj == null) {
            INITIALIZED_TAGS.put(this.getClass(), this);
            log.info("Initializer = {} start ####", (Object)this.getClass().getName());
            this.init();
            log.info("Initializer = {} end ####", (Object)this.getClass().getName());
        }
    }

    public static <T> T get(Class<T> clazz) {
        return (T)INITIALIZED_TAGS.get(clazz);
    }

    public abstract void init() throws InitException;

    @Override
    @Generated
    public void setDebugOption(DebugOption debugOption) {
        this.debugOption = debugOption;
    }

    @Generated
    public void setClassScanner(ClassScanner classScanner) {
        this.classScanner = classScanner;
    }
}

