/*
 * Decompiled with CFR 0.152.
 */
package io.github.kylinhunter.commons.init;

import io.github.kylinhunter.commons.collections.SetUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Set;
import java.util.function.Predicate;
import org.reflections.ReflectionUtils;
import org.reflections.Reflections;
import org.reflections.scanners.Scanners;

public class ClassScanner {
    private final Set<String> allPackages;
    private final Reflections reflections;

    public ClassScanner(String pkg) {
        this(SetUtils.newHashSet(pkg));
    }

    public ClassScanner(Set<String> allPackages) {
        this.allPackages = allPackages;
        this.reflections = new Reflections(new Object[]{allPackages, Scanners.SubTypes, Scanners.TypesAnnotated, Scanners.FieldsAnnotated});
    }

    public <T> Set<Class<? extends T>> getSubTypesOf(Class<T> type) {
        return this.reflections.getSubTypesOf(type);
    }

    public Set<Class<?>> getTypesAnnotatedWith(Class<? extends Annotation> annotation) {
        return this.reflections.getTypesAnnotatedWith(annotation);
    }

    public Set<Field> getFieldsAnnotatedWith(Class<? extends Annotation> annotation) {
        return this.reflections.getFieldsAnnotatedWith(annotation);
    }

    public Set<Class<?>> getAllInterface(Class<?> clazz) {
        return ReflectionUtils.getAllSuperTypes(clazz, (Predicate[])new Predicate[]{c -> c.isInterface() && this.isValid((Class<?>)c)});
    }

    public boolean isValid(Class<?> clazz) {
        for (String pkg : this.allPackages) {
            if (!clazz.getPackage().getName().contains(pkg)) continue;
            return true;
        }
        return false;
    }

    public Set<Class<?>> getClassesByAnnotatedWith(Class<? extends Annotation> annotation) {
        return this.reflections.getTypesAnnotatedWith(annotation);
    }
}

