/*
 * Decompiled with CFR 0.152.
 */
package io.github.kylinhunter.commons.init;

import io.github.kylinhunter.commons.collections.ListUtils;
import io.github.kylinhunter.commons.collections.MapUtils;
import io.github.kylinhunter.commons.collections.SetUtils;
import io.github.kylinhunter.commons.init.AbstractInitializer;
import io.github.kylinhunter.commons.init.ClassScanner;
import io.github.kylinhunter.commons.init.DebugOption;
import io.github.kylinhunter.commons.init.Initializer;
import io.github.kylinhunter.commons.init.Order;
import io.github.kylinhunter.commons.reflect.Constructors;
import io.github.kylinhunter.commons.reflect.ObjectCreator;
import io.github.kylinhunter.commons.sys.KGenerated;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Logger;

@KGenerated
public class KCommons {
    private static final Logger log = Logger.getLogger(KCommons.class.toString());
    private static final KCommons K_COMMONS = new KCommons();
    private final Set<String> allPackages = SetUtils.newHashSet();
    private DebugOption debugOption;

    public KCommons() {
        this.scanPackage("io.github.kylinhunter");
    }

    public static KCommons custom() {
        return K_COMMONS;
    }

    public KCommons scanPackage(String pkg) {
        this.allPackages.add(pkg);
        return this;
    }

    public KCommons cleanPackage() {
        this.allPackages.clear();
        return this;
    }

    public KCommons debug(boolean debug) {
        if (debug) {
            this.debugOption(DebugOption.INSTANCE);
        }
        return this;
    }

    public KCommons debugOption(DebugOption debugOption) {
        this.debugOption = debugOption;
        return this;
    }

    public void init() {
        ClassScanner classScanner = new ClassScanner(this.allPackages);
        TreeMap<Integer, List> treeMap = MapUtils.newTreeMap();
        for (Class<AbstractInitializer> clazz : classScanner.getSubTypesOf(AbstractInitializer.class)) {
            Order order = clazz.getAnnotation(Order.class);
            int orderNum = order != null ? order.value() : 0;
            treeMap.compute(orderNum, (k, v) -> {
                if (v == null) {
                    v = ListUtils.newArrayList();
                }
                v.add(clazz);
                return v;
            });
        }
        treeMap.forEach((k, clazzes) -> {
            for (Class clazz : clazzes) {
                log.info("init " + clazz.getName());
                Constructor constructor = Constructors.getConstructor(clazz, ClassScanner.class);
                Initializer initializer = (Initializer)ObjectCreator.create(constructor, classScanner);
                initializer.setDebugOption(this.debugOption);
                initializer.initialize();
            }
        });
    }
}

