/*
 * Decompiled with CFR 0.152.
 */
package io.github.kylinhunter.commons.io;

import io.github.kylinhunter.commons.collections.ArrayUtils;
import io.github.kylinhunter.commons.exception.embed.KIOException;
import io.github.kylinhunter.commons.io.Charsets;
import io.github.kylinhunter.commons.io.output.StringBuilderWriter;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class IOUtil {
    public static final int EOF = -1;
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static final ThreadLocal<char[]> SKIP_CHAR_BUFFER = ThreadLocal.withInitial(IOUtil::charArray);

    private static char[] charArray() {
        return IOUtil.charArray(8192);
    }

    private static char[] charArray(int size) {
        return new char[size];
    }

    public static byte[] byteArray(int size) {
        return new byte[size];
    }

    public static byte[] byteArray() {
        return IOUtil.byteArray(8192);
    }

    public static List<String> readLines(InputStream input, Charset charset) throws IOException {
        InputStreamReader reader = new InputStreamReader(input, Charsets.toCharset(charset));
        return IOUtil.readLines(reader);
    }

    public static List<String> readLines(Reader reader) throws IOException {
        String line;
        BufferedReader bufReader = IOUtil.toBufferedReader(reader);
        ArrayList<String> list = new ArrayList<String>();
        while ((line = bufReader.readLine()) != null) {
            list.add(line);
        }
        return list;
    }

    public static BufferedReader toBufferedReader(Reader reader) {
        return reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
    }

    public static String toString(InputStream input, Charset charset) throws IOException {
        try (StringBuilderWriter sw = new StringBuilderWriter();){
            IOUtil.copy(input, sw, charset);
            String string = sw.toString();
            return string;
        }
    }

    public static void copy(InputStream input, Writer writer, Charset inputCharset) throws IOException {
        InputStreamReader reader = new InputStreamReader(input, Charsets.toCharset(inputCharset));
        IOUtil.copy(reader, writer);
    }

    public static int copy(Reader reader, Writer writer) throws IOException {
        long count = IOUtil.copyLarge(reader, writer);
        if (count > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)count;
    }

    public static long copyLarge(Reader reader, Writer writer) throws IOException {
        return IOUtil.copyLarge(reader, writer, IOUtil.getCharArray());
    }

    public static long copyLarge(Reader reader, Writer writer, char[] buffer) throws IOException {
        int n;
        long count = 0L;
        while (-1 != (n = reader.read(buffer))) {
            writer.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    static char[] getCharArray() {
        return SKIP_CHAR_BUFFER.get();
    }

    public static byte[] toByteArray(InputStream input, long size) throws IOException {
        if (size > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Size cannot be greater than Integer max value: " + size);
        }
        return IOUtil.toByteArray(input, (int)size);
    }

    public static byte[] toByteArray(InputStream input, int size) throws IOException {
        int offset;
        int read;
        if (size < 0) {
            throw new IllegalArgumentException("Size must be equal or greater than zero: " + size);
        }
        if (size == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        byte[] data = IOUtil.byteArray(size);
        for (offset = 0; offset < size && (read = input.read(data, offset, size - offset)) != -1; offset += read) {
        }
        if (offset != size) {
            throw new IOException("Unexpected read size, current: " + offset + ", expected: " + size);
        }
        return data;
    }

    public static byte[] toByteArray(InputStream inputStream) {
        byte[] byArray;
        ByteArrayOutputStream ubaOutput = new ByteArrayOutputStream();
        try {
            IOUtil.copy(inputStream, ubaOutput);
            byArray = ubaOutput.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    ubaOutput.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new KIOException("toByteArray error", (Throwable)e);
            }
        }
        ubaOutput.close();
        return byArray;
    }

    public static int copy(InputStream inputStream, OutputStream outputStream) {
        long count = IOUtil.copyLarge(inputStream, outputStream);
        if (count > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)count;
    }

    public static long copyLarge(InputStream inputStream, OutputStream outputStream) {
        return IOUtil.copy(inputStream, outputStream, 8192);
    }

    public static long copy(InputStream inputStream, OutputStream outputStream, int bufferSize) {
        return IOUtil.copyLarge(inputStream, outputStream, IOUtil.byteArray(bufferSize));
    }

    public static long copyLarge(InputStream inputStream, OutputStream outputStream, byte[] buffer) {
        Objects.requireNonNull(inputStream, "inputStream");
        Objects.requireNonNull(outputStream, "outputStream");
        long count = 0L;
        try {
            int n;
            while (-1 != (n = inputStream.read(buffer))) {
                outputStream.write(buffer, 0, n);
                count += (long)n;
            }
        }
        catch (IOException e) {
            throw new KIOException("copyLarge error", (Throwable)e);
        }
        return count;
    }

    public static void closeQuietly(Closeable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeQuietly(AutoCloseable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static String toString(byte[] body, Charset charset, int charLen) {
        String string;
        if (ArrayUtils.isEmpty(body)) {
            return "";
        }
        charset = Charsets.defaultCharset(charset, Charsets.UTF_8);
        if (charLen <= 0 || body.length < charLen) {
            return new String(body, charset);
        }
        InputStreamReader reader = new InputStreamReader((InputStream)new ByteArrayInputStream(body), charset);
        try {
            string = IOUtil.toString(reader, charLen);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new KIOException("toString error", (Throwable)e);
            }
        }
        ((Reader)reader).close();
        return string;
    }

    public static String toString(InputStream input, Charset charset, int charLen) {
        String string;
        if (input == null) {
            return "";
        }
        charset = Charsets.defaultCharset(charset, Charsets.UTF_8);
        if (charLen <= 0) {
            byte[] bytes = IOUtil.toByteArray(input);
            return new String(bytes, charset);
        }
        InputStreamReader reader = new InputStreamReader(input, charset);
        try {
            string = IOUtil.toString(reader, charLen);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new KIOException("toString error", (Throwable)e);
            }
        }
        ((Reader)reader).close();
        return string;
    }

    public static String toString(Reader reader, int charLen) throws IOException {
        CharBuffer result = CharBuffer.allocate(charLen);
        int readLength = reader.read(result);
        result.flip();
        if (readLength > 0) {
            Object resultText = result.toString();
            result.clear();
            readLength = reader.read(result);
            if (readLength > 0) {
                resultText = (String)resultText + "...";
            }
            return resultText;
        }
        return "";
    }
}

