/*
 * Decompiled with CFR 0.152.
 */
package io.github.kylinhunter.commons.io;

import io.github.kylinhunter.commons.exception.embed.KIOException;
import io.github.kylinhunter.commons.io.IOHelper;
import io.github.kylinhunter.commons.io.IOUtil;
import io.github.kylinhunter.commons.io.file.FileUtil;
import io.github.kylinhunter.commons.io.file.UserDirUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Objects;
import lombok.Generated;

public class ResourceHelper {
    public static InputStream getInputStream(String path) {
        return ResourceHelper.getInputStream(path, PathType.CLASSPATH, false);
    }

    public static InputStream getInputStream(String path, boolean required) {
        return ResourceHelper.getInputStream(path, PathType.CLASSPATH, required);
    }

    public static InputStream getInputStream(String path, PathType priorityType) {
        return ResourceHelper.getInputStream(path, priorityType, false);
    }

    public static InputStream getInputStream(String path, PathType priorityType, boolean required) {
        try {
            InputStream inputStream;
            PathInfo pathInfo = new PathInfo(path);
            PathType pathType = pathInfo.getType();
            if (pathType == PathType.CLASSPATH) {
                inputStream = ResourceHelper.getInputStreamInClassPath(pathInfo.getPath());
            } else if (pathType == PathType.FILESYSTEM) {
                inputStream = FileUtil.openInputStream(pathInfo.getFile());
            } else if (priorityType == PathType.FILESYSTEM) {
                inputStream = FileUtil.openInputStream(FileUtil.getFile(path));
                if (inputStream == null) {
                    inputStream = ResourceHelper.getInputStreamInClassPath(path);
                }
            } else {
                inputStream = ResourceHelper.getInputStreamInClassPath(path);
                if (inputStream == null) {
                    inputStream = FileUtil.openInputStream(FileUtil.getFile(path));
                }
            }
            return Objects.requireNonNull(inputStream);
        }
        catch (Exception e) {
            if (required) {
                throw new KIOException("can't get inputStream :" + path, (Throwable)e);
            }
            return null;
        }
    }

    public static InputStream getInputStreamInClassPath(String classPath) {
        InputStream in = ResourceHelper.class.getClassLoader().getResourceAsStream(classPath);
        if (in != null) {
            return in;
        }
        return ResourceHelper.class.getResourceAsStream(classPath);
    }

    public static File getFile(String path) {
        return ResourceHelper.getFile(path, true, PathType.CLASSPATH, false);
    }

    public static File getFile(String path, boolean required) {
        return ResourceHelper.getFile(path, true, PathType.CLASSPATH, required);
    }

    public static File getFile(String path, PathType priorityType) {
        return ResourceHelper.getFile(path, true, priorityType, false);
    }

    public static File getFile(String path, PathType priorityType, boolean required) {
        return ResourceHelper.getFile(path, true, priorityType, required);
    }

    public static File getDir(String path) {
        return ResourceHelper.getFile(path, false, PathType.CLASSPATH, false);
    }

    public static File getDir(String path, boolean required) {
        return ResourceHelper.getFile(path, false, PathType.CLASSPATH, required);
    }

    public static File getDir(String path, PathType priorityType) {
        return ResourceHelper.getFile(path, false, priorityType, false);
    }

    public static File getDir(String path, PathType priorityType, boolean required) {
        return ResourceHelper.getFile(path, false, priorityType, required);
    }

    private static File getFile(String path, boolean isFile, PathType priorityType, boolean required) {
        try {
            File file;
            PathInfo pathInfo = new PathInfo(path);
            PathType pathType = pathInfo.getType();
            if (pathType == PathType.CLASSPATH) {
                file = ResourceHelper._getFileInClassPath(pathInfo.getPath());
            } else if (pathType == PathType.FILESYSTEM) {
                file = pathInfo.getFile();
            } else if (priorityType == PathType.FILESYSTEM) {
                try {
                    File fileOrDir = FileUtil.getFileOrDir(null, false, false, isFile, path);
                    return FileUtil.checkValidFile(fileOrDir, isFile);
                }
                catch (Exception e) {
                    file = ResourceHelper._getFileInClassPath(pathInfo.getPath());
                }
            } else {
                try {
                    return FileUtil.checkValidFile(ResourceHelper._getFileInClassPath(pathInfo.getPath()), isFile);
                }
                catch (Exception e) {
                    file = FileUtil.getFile(path);
                }
            }
            return FileUtil.checkValidFile(file, isFile);
        }
        catch (Exception e) {
            if (required) {
                throw new KIOException("can't get file :" + path, (Throwable)e);
            }
            return null;
        }
    }

    public static File getFileInClassPath(String classPath) {
        return ResourceHelper.getFileInClassPath(classPath, true, false);
    }

    public static File getFileInClassPath(String classPath, boolean required) {
        return ResourceHelper.getFileInClassPath(classPath, true, required);
    }

    public static File getDirInClassPath(String classPath) {
        return ResourceHelper.getFileInClassPath(classPath, false, false);
    }

    public static File getDirInClassPath(String classPath, boolean required) {
        return ResourceHelper.getFileInClassPath(classPath, false, required);
    }

    private static File getFileInClassPath(String classPath, boolean isFile, boolean required) {
        try {
            File file = ResourceHelper._getFileInClassPath(classPath);
            return FileUtil.checkValidFile(file, isFile);
        }
        catch (Exception e) {
            if (required) {
                throw new KIOException("can't get file :" + classPath, (Throwable)e);
            }
            return null;
        }
    }

    private static File _getFileInClassPath(String classPath) {
        try {
            URL url = ResourceHelper.class.getClassLoader().getResource(classPath);
            if (url == null) {
                url = ResourceHelper.class.getResource(classPath);
            }
            if (url != null) {
                File file = new File(url.getPath());
                if (file.exists()) {
                    return file;
                }
                String path = url.toURI().getPath();
                if (path != null && (file = new File(path)).exists()) {
                    return file;
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new KIOException("get file from classpath error", (Throwable)e);
        }
    }

    public static String getText(String path) {
        return ResourceHelper.getText(path, PathType.CLASSPATH, Charset.defaultCharset());
    }

    public static String getText(String path, PathType priorityType) {
        return ResourceHelper.getText(path, priorityType, Charset.defaultCharset());
    }

    public static String getText(String path, Charset charset) {
        return ResourceHelper.getText(path, PathType.CLASSPATH, charset);
    }

    public static String getText(String path, PathType priorityType, Charset charset) {
        String string;
        block8: {
            InputStream inputStream = ResourceHelper.getInputStream(path, priorityType, true);
            try {
                string = IOUtil.toString(inputStream, charset);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new KIOException("get text error", (Throwable)e);
                }
            }
            inputStream.close();
        }
        return string;
    }

    public static List<String> readLines(String path) {
        return ResourceHelper.readLines(path, PathType.CLASSPATH, Charset.defaultCharset());
    }

    public static List<String> readLines(String path, PathType priorityType) {
        return ResourceHelper.readLines(path, priorityType, Charset.defaultCharset());
    }

    public static List<String> readLines(String path, Charset charset) {
        return ResourceHelper.readLines(path, PathType.CLASSPATH, charset);
    }

    public static List<String> readLines(String path, PathType priorityType, Charset charset) {
        List<String> list;
        block8: {
            InputStream inputStream = ResourceHelper.getInputStream(path, priorityType, true);
            try {
                list = IOUtil.readLines(inputStream, charset);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new KIOException("get text error", (Throwable)e);
                }
            }
            inputStream.close();
        }
        return list;
    }

    public static enum PathType {
        CLASSPATH,
        FILESYSTEM,
        UNKNOWN;

    }

    public static class PathInfo {
        public static final String USER_DIR_TAG = "$user.dir$";
        public static final String PROTOCOL_FILE = "file:";
        public static final String CLASSPATH_TAG = "classpath:";
        private PathType type;
        private File file;
        private String path;
        private String originalPath;

        public PathInfo(String path) {
            this.originalPath = path;
            if (path.startsWith(CLASSPATH_TAG)) {
                this.type = PathType.CLASSPATH;
                this.path = path.substring(CLASSPATH_TAG.length());
            } else if (path.startsWith(PROTOCOL_FILE)) {
                this.type = PathType.FILESYSTEM;
                this.file = FileUtil.newFile(IOHelper.toURI(path));
                this.path = this.file.getAbsolutePath();
            } else if (path.startsWith(USER_DIR_TAG)) {
                this.type = PathType.FILESYSTEM;
                String replacePath = path.replace(USER_DIR_TAG, UserDirUtils.get().getAbsolutePath());
                this.file = FileUtil.newFile(replacePath);
                this.path = this.file.getAbsolutePath();
            } else {
                this.type = PathType.UNKNOWN;
                this.path = path;
            }
        }

        @Generated
        public PathType getType() {
            return this.type;
        }

        @Generated
        public File getFile() {
            return this.file;
        }

        @Generated
        public String getPath() {
            return this.path;
        }

        @Generated
        public String getOriginalPath() {
            return this.originalPath;
        }

        @Generated
        public void setType(PathType type) {
            this.type = type;
        }

        @Generated
        public void setFile(File file) {
            this.file = file;
        }

        @Generated
        public void setPath(String path) {
            this.path = path;
        }

        @Generated
        public void setOriginalPath(String originalPath) {
            this.originalPath = originalPath;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PathInfo)) {
                return false;
            }
            PathInfo other = (PathInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            PathType this$type = this.getType();
            PathType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            File this$file = this.getFile();
            File other$file = other.getFile();
            if (this$file == null ? other$file != null : !((Object)this$file).equals(other$file)) {
                return false;
            }
            String this$path = this.getPath();
            String other$path = other.getPath();
            if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
                return false;
            }
            String this$originalPath = this.getOriginalPath();
            String other$originalPath = other.getOriginalPath();
            return !(this$originalPath == null ? other$originalPath != null : !this$originalPath.equals(other$originalPath));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PathInfo;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            PathType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            File $file = this.getFile();
            result = result * 59 + ($file == null ? 43 : ((Object)$file).hashCode());
            String $path = this.getPath();
            result = result * 59 + ($path == null ? 43 : $path.hashCode());
            String $originalPath = this.getOriginalPath();
            result = result * 59 + ($originalPath == null ? 43 : $originalPath.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ResourceHelper.PathInfo(type=" + this.getType() + ", file=" + this.getFile() + ", path=" + this.getPath() + ", originalPath=" + this.getOriginalPath() + ")";
        }
    }
}

