/*
 * Decompiled with CFR 0.152.
 */
package io.github.kylinhunter.commons.io.file;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.github.kylinhunter.commons.exception.ExCatcher;
import io.github.kylinhunter.commons.exception.check.ThrowChecker;
import io.github.kylinhunter.commons.exception.embed.KIOException;
import io.github.kylinhunter.commons.io.file.filter.DefaultPathFilter;
import io.github.kylinhunter.commons.io.file.filter.SuffixPathFilter;
import io.github.kylinhunter.commons.io.file.path.PathUtil;
import io.github.kylinhunter.commons.lang.strings.StringUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"})
public class FileUtil {
    public static File newFile(String pathname) {
        return new File(pathname);
    }

    public static File newFile(URI uri) {
        return new File(uri);
    }

    public static File newFile(String parent, String child) {
        return new File(parent, child);
    }

    public static File newFile(File parent, String child) {
        return new File(parent, child);
    }

    public static void delete(File file) {
        try {
            Objects.requireNonNull(file, "file");
            Files.delete(file.toPath());
        }
        catch (IOException e) {
            throw new KIOException("delete error", (Throwable)e);
        }
    }

    public static File getFileOrDir(File directory, boolean createParent, boolean createFile, boolean isFile, String ... names) {
        Objects.requireNonNull(names, "names");
        File file = directory;
        for (String name : names) {
            ThrowChecker.checkNotEmpty(name, "name can't be empty");
            file = file == null ? FileUtil.newFile(name) : FileUtil.newFile(file, name);
        }
        if (file.exists()) {
            if (isFile && file.isDirectory()) {
                throw new KIOException("not a file=>" + file.getAbsolutePath());
            }
            if (!isFile && file.isFile()) {
                throw new KIOException("not a dir=>" + file.getAbsolutePath());
            }
            return file;
        }
        if (createParent || createFile) {
            if (!isFile) {
                FileUtil.forceMkdir(file);
            } else {
                FileUtil.forceMkdirParent(file);
            }
        }
        if (createFile) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                throw new KIOException("create file error", (Throwable)e);
            }
        }
        return file;
    }

    public static File getFile(File directory, boolean createParent, boolean createFile, String ... names) {
        return FileUtil.getFileOrDir(directory, createParent, createFile, true, names);
    }

    public static File getFile(File dir, String ... names) {
        return FileUtil.getFile(dir, false, false, names);
    }

    public static File getFile(File dir, boolean createParent, String ... names) {
        return FileUtil.getFile(dir, createParent, false, names);
    }

    public static File getFile(String ... names) {
        return FileUtil.getFile(null, false, false, names);
    }

    public static File getFile(boolean createParent, String ... names) {
        return FileUtil.getFile(null, createParent, false, names);
    }

    public static File getFile(boolean createParent, boolean createFile, String ... names) {
        return FileUtil.getFile(null, createParent, createFile, names);
    }

    public static File getDir(File dir, boolean create, String ... names) {
        return FileUtil.getFileOrDir(dir, create, false, false, names);
    }

    public static File getDir(File dir, String ... names) {
        return FileUtil.getDir(dir, false, names);
    }

    public static File getDir(String ... names) {
        return FileUtil.getDir(null, false, names);
    }

    public static File getDir(boolean createParent, String ... names) {
        return FileUtil.getDir(null, createParent, names);
    }

    public static boolean isEmptyDirectory(File directory) {
        return PathUtil.isEmptyDirectory(directory.toPath());
    }

    public static Collection<File> listFiles(File directory, String[] extensions, boolean recursive) {
        try (Stream<File> paths = FileUtil.streamFiles(directory, recursive, extensions);){
            Collection collection = paths.collect(Collectors.toList());
            return collection;
        }
    }

    public static Stream<File> streamFiles(File directory, boolean recursive, String ... extensions) {
        DefaultPathFilter filter = extensions == null ? DefaultPathFilter.INSTANCE : DefaultPathFilter.INSTANCE.and(new SuffixPathFilter(extensions));
        int dep = recursive ? Integer.MAX_VALUE : 1;
        return PathUtil.walk(directory.toPath(), filter, dep, false, new FileVisitOption[0]).map(Path::toFile);
    }

    public static void forceMkdirParent(File file) {
        Objects.requireNonNull(file, "file");
        File parent = file.getParentFile();
        if (parent == null) {
            return;
        }
        if (!parent.mkdirs() && !parent.isDirectory()) {
            throw new KIOException("Cannot create directory '" + parent + "'.");
        }
    }

    public static File forceMkdir(File directory) {
        if (directory != null && !directory.mkdirs() && !directory.isDirectory()) {
            throw new KIOException("Cannot create directory '" + directory + "'.");
        }
        return directory;
    }

    public static void cleanDirectoryQuietly(File file) {
        try {
            FileUtil.cleanDirectory(file);
        }
        catch (KIOException kIOException) {
            // empty catch block
        }
    }

    public static void cleanDirectory(File directory) {
        try {
            File[] files;
            for (File file : files = FileUtil.listFiles(directory, null)) {
                FileUtil.forceDelete(file);
            }
        }
        catch (Exception e) {
            throw new KIOException("clean directory error", (Throwable)e);
        }
    }

    public static boolean deleteQuietly(File file) {
        if (file == null) {
            return false;
        }
        try {
            if (file.isDirectory()) {
                FileUtil.cleanDirectory(file);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            return file.delete();
        }
        catch (Exception ignored) {
            return false;
        }
    }

    private static File[] listFiles(File directory, FileFilter fileFilter) {
        File[] files;
        FileUtil.checkValidFile(directory, false, "directory");
        File[] fileArray = files = fileFilter == null ? directory.listFiles() : directory.listFiles(fileFilter);
        if (files == null) {
            throw new KIOException("Unknown I/O error listing contents of directory: " + directory);
        }
        return files;
    }

    public static void forceDelete(File file) {
        Objects.requireNonNull(file, "file");
        PathUtil.delete(file.toPath(), PathUtil.EMPTY_LINK_OPTION_ARRAY);
    }

    public static File checkValidFile(File file, boolean isFile) {
        return FileUtil.checkValidFile(file, isFile, null);
    }

    public static File checkValidFile(File file, boolean isFile, String name) {
        name = StringUtil.defaultString((String)name) + " ";
        if (file == null) {
            throw new KIOException((String)name + "file can't be null");
        }
        if (file.exists()) {
            if (isFile && !file.isFile()) {
                throw new KIOException((String)name + "not a file :" + file.getAbsolutePath());
            }
            if (!isFile && !file.isDirectory()) {
                throw new KIOException((String)name + "not a directory :" + file.getAbsolutePath());
            }
        } else {
            throw new KIOException((String)name + "no exist :" + file.getAbsolutePath());
        }
        return file;
    }

    public static FileInputStream openInputStream(File file) {
        return ExCatcher.run(() -> {
            Objects.requireNonNull(file, "file");
            return new FileInputStream(file);
        });
    }
}

