/*
 * Decompiled with CFR 0.152.
 */
package io.github.kylinhunter.commons.io.file;

import io.github.kylinhunter.commons.collections.MapUtils;
import java.io.File;
import java.util.Map;

public class FilenameUtils {
    private static final String EMPTY_STRING = "";
    private static final int NOT_FOUND = -1;
    private static final char UNIX_SEPARATOR = '/';
    private static final char WINDOWS_SEPARATOR = '\\';
    public static final char EXTENSION_SEPARATOR = '.';
    private static final char SYSTEM_SEPARATOR = File.separatorChar;
    private static final char OTHER_SEPARATOR = FilenameUtils.isSystemWindows() ? (char)47 : (char)92;
    private static final Map<String, String> ACTUAL_EXTENSIONS = MapUtils.newHashMap();

    public static String getExtension(String fileName) {
        String extension = FilenameUtils._getExtension(fileName);
        if (extension != null && extension.length() > 0) {
            String actualExtension = ACTUAL_EXTENSIONS.get(extension.toLowerCase());
            if (actualExtension != null && fileName.toLowerCase().endsWith(actualExtension)) {
                return actualExtension;
            }
            return extension.toLowerCase();
        }
        return EMPTY_STRING;
    }

    private static String _getExtension(String fileName) throws IllegalArgumentException {
        if (fileName == null) {
            return null;
        }
        int index = FilenameUtils.indexOfExtension(fileName);
        if (index == -1) {
            return EMPTY_STRING;
        }
        return fileName.substring(index + 1);
    }

    public static int indexOfExtension(String fileName) throws IllegalArgumentException {
        int offset;
        if (fileName == null) {
            return -1;
        }
        if (FilenameUtils.isSystemWindows() && (offset = fileName.indexOf(58, FilenameUtils.getAdsCriticalOffset(fileName))) != -1) {
            throw new IllegalArgumentException("NTFS ADS separator (':') in file name is forbidden.");
        }
        int extensionPos = fileName.lastIndexOf(46);
        int lastSeparator = FilenameUtils.indexOfLastSeparator(fileName);
        return lastSeparator > extensionPos ? -1 : extensionPos;
    }

    private static int getAdsCriticalOffset(String fileName) {
        int offset1 = fileName.lastIndexOf(SYSTEM_SEPARATOR);
        int offset2 = fileName.lastIndexOf(OTHER_SEPARATOR);
        if (offset1 == -1) {
            if (offset2 == -1) {
                return 0;
            }
            return offset2 + 1;
        }
        if (offset2 == -1) {
            return offset1 + 1;
        }
        return Math.max(offset1, offset2) + 1;
    }

    public static int indexOfLastSeparator(String fileName) {
        if (fileName == null) {
            return -1;
        }
        int lastUnixPos = fileName.lastIndexOf(47);
        int lastWindowsPos = fileName.lastIndexOf(92);
        return Math.max(lastUnixPos, lastWindowsPos);
    }

    public static boolean isSystemWindows() {
        return SYSTEM_SEPARATOR == '\\';
    }

    static {
        ACTUAL_EXTENSIONS.put("z", "tar.z");
        ACTUAL_EXTENSIONS.put("gz", "tar.gz");
    }
}

