/*
 * Decompiled with CFR 0.152.
 */
package io.github.kylinhunter.commons.io.file;

import io.github.kylinhunter.commons.io.file.FileUtil;
import java.io.File;

public class UserDirUtils {
    private static final File USER_DIR = new File(System.getProperty("user.dir"));
    private static final String PATH_OF_USER_DIR = USER_DIR.getAbsolutePath();
    private static final File USER_DIR_CONFIG = new File(System.getProperty("user.dir"), "config");
    private static final File USER_DIR_TMP = new File(System.getProperty("user.dir"), "tmp");

    public static File get() {
        return USER_DIR;
    }

    public static File getDir(String ... child) {
        return FileUtil.getDir(USER_DIR, true, child);
    }

    public static File getDir(boolean create, String ... child) {
        return FileUtil.getDir(USER_DIR, create, child);
    }

    public static File getFile(String ... child) {
        return FileUtil.getFile(USER_DIR, true, false, child);
    }

    public static File getFile(boolean createParent, String child) {
        return FileUtil.getFile(USER_DIR, createParent, false, child);
    }

    public static File getFile(boolean createParent, boolean createFile, String child) {
        return FileUtil.getFile(USER_DIR, createParent, createFile, child);
    }

    public static File getTmpDir() {
        return FileUtil.getDir(USER_DIR_TMP, true, new String[0]);
    }

    public static File getTmpDir(String ... child) {
        return FileUtil.getDir(USER_DIR_TMP, true, child);
    }

    public static File getTmpDir(boolean create, String child) {
        return FileUtil.getDir(USER_DIR_TMP, true, child);
    }

    public static File getTmpFile(String child) {
        return FileUtil.getFile(USER_DIR_TMP, true, false, child);
    }

    public static File getTmpFile(boolean createParent, String ... child) {
        return FileUtil.getFile(USER_DIR_TMP, createParent, false, child);
    }

    public static File getTmpFile(boolean createParent, boolean createFile, String ... child) {
        return FileUtil.getFile(USER_DIR_TMP, createParent, createFile, child);
    }

    public static File getDirConfig() {
        return FileUtil.getDir(USER_DIR_TMP, true, new String[0]);
    }

    public static void deleteQuietly(File file) {
        if (file != null && file.getAbsolutePath().startsWith(PATH_OF_USER_DIR)) {
            FileUtil.deleteQuietly(file);
        }
    }
}

