/*
 * Decompiled with CFR 0.152.
 */
package io.github.kylinhunter.commons.io.file.filter;

import io.github.kylinhunter.commons.collections.ListUtils;
import io.github.kylinhunter.commons.io.file.filter.AbstractPathFilter;
import io.github.kylinhunter.commons.io.file.filter.PathFilter;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;
import java.util.Objects;

public class OrPathFilter
extends AbstractPathFilter {
    private final List<PathFilter> fileFilters;

    public OrPathFilter(List<PathFilter> fileFilters) {
        this.fileFilters = Objects.requireNonNull(fileFilters, "fileFilters");
    }

    public OrPathFilter(PathFilter filter1, PathFilter filter2) {
        this.fileFilters = ListUtils.newArrayListWithCapacity(2);
        this.addPathFilter(filter1);
        this.addPathFilter(filter2);
    }

    public void addPathFilter(PathFilter ... fileFilters) {
        for (PathFilter fileFilter : Objects.requireNonNull(fileFilters, "fileFilters")) {
            this.fileFilters.add(fileFilter);
        }
    }

    @Override
    public FileVisitResult accept(Path file, BasicFileAttributes attributes) {
        for (PathFilter fileFilter : this.fileFilters) {
            if (fileFilter.accept(file, attributes) != FileVisitResult.CONTINUE) continue;
            return FileVisitResult.CONTINUE;
        }
        return FileVisitResult.TERMINATE;
    }
}

