/*
 * Decompiled with CFR 0.152.
 */
package io.github.kylinhunter.commons.io.file.filter;

import io.github.kylinhunter.commons.io.IOCase;
import io.github.kylinhunter.commons.io.file.filter.AbstractPathFilter;
import io.github.kylinhunter.commons.lang.strings.StringUtil;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;
import java.util.Objects;

public class SuffixPathFilter
extends AbstractPathFilter {
    private final String[] suffixes;
    private final IOCase ioCase;

    public SuffixPathFilter(String ... suffixes) {
        this(suffixes, IOCase.SENSITIVE);
    }

    public SuffixPathFilter(String[] suffixes, IOCase ioCase) {
        Objects.requireNonNull(suffixes, "suffixes must not be null");
        this.suffixes = new String[suffixes.length];
        System.arraycopy(suffixes, 0, this.suffixes, 0, suffixes.length);
        this.initSuffixes();
        this.ioCase = ioCase == null ? IOCase.SENSITIVE : ioCase;
    }

    public SuffixPathFilter(List<String> suffixes) {
        this(suffixes, IOCase.SENSITIVE);
    }

    public SuffixPathFilter(List<String> suffixes, IOCase ioCase) {
        Objects.requireNonNull(suffixes, "suffixes must not be null");
        this.suffixes = suffixes.toArray(StringUtil.EMPTY_STRING_ARRAY);
        this.initSuffixes();
        this.ioCase = ioCase == null ? IOCase.SENSITIVE : ioCase;
    }

    private void initSuffixes() {
        for (int i = 0; i < this.suffixes.length; ++i) {
            if (this.suffixes[i].startsWith(".")) continue;
            this.suffixes[i] = "." + this.suffixes[i];
        }
    }

    @Override
    public FileVisitResult accept(Path file, BasicFileAttributes attributes) {
        if (this.accept(Objects.toString(file.getFileName(), null))) {
            return FileVisitResult.CONTINUE;
        }
        return FileVisitResult.TERMINATE;
    }

    private boolean accept(String name) {
        for (String suffix : this.suffixes) {
            if (!this.ioCase.checkEndsWith(name, suffix)) continue;
            return true;
        }
        return false;
    }
}

