/*
 * Decompiled with CFR 0.152.
 */
package io.github.kylinhunter.commons.io.file.path;

import io.github.kylinhunter.commons.io.file.path.PathUtil;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;

public class DeletingPathVisitor
extends SimpleFileVisitor<Path> {
    private final LinkOption[] linkOptions;

    public DeletingPathVisitor() {
        this.linkOptions = PathUtil.NOFOLLOW_LINK_OPTION_ARRAY;
    }

    public DeletingPathVisitor(LinkOption[] linkOptions) {
        this.linkOptions = linkOptions != null ? linkOptions : PathUtil.NOFOLLOW_LINK_OPTION_ARRAY;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        return super.preVisitDirectory(dir, attrs);
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        super.visitFile(file, attrs);
        if (Files.exists(file, this.linkOptions)) {
            Files.deleteIfExists(file);
        }
        if (Files.isSymbolicLink(file)) {
            try {
                Files.delete(file);
            }
            catch (NoSuchFileException noSuchFileException) {
                // empty catch block
            }
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
        return super.visitFileFailed(file, exc);
    }

    @Override
    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
        if (PathUtil.isEmptyDirectory(dir)) {
            Files.deleteIfExists(dir);
        }
        return FileVisitResult.CONTINUE;
    }
}

