/*
 * Decompiled with CFR 0.152.
 */
package io.github.kylinhunter.commons.io.file.path;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.github.kylinhunter.commons.exception.embed.KIOException;
import io.github.kylinhunter.commons.io.file.filter.PathFilter;
import io.github.kylinhunter.commons.io.file.path.DeletingPathVisitor;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.stream.Stream;

public class PathUtil {
    @SuppressFBWarnings(value={"MS_PKGPROTECT"})
    public static final LinkOption[] NOFOLLOW_LINK_OPTION_ARRAY = new LinkOption[]{LinkOption.NOFOLLOW_LINKS};
    public static final LinkOption[] EMPTY_LINK_OPTION_ARRAY = new LinkOption[0];

    public static void checkDir(Path path) {
        PathUtil.checkDir(path, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void checkDir(Path path, boolean create) {
        Objects.requireNonNull(path);
        if (!Files.exists(path, new LinkOption[0])) {
            if (!create) throw new KIOException(" no exist " + path);
            PathUtil.createDirectories(path, new FileAttribute[0]);
            return;
        } else {
            if (Files.isDirectory(path, new LinkOption[0])) return;
            throw new KIOException(" not a dir " + path);
        }
    }

    public static Path createDirectories(Path path, FileAttribute<?> ... attrs) throws KIOException {
        Objects.requireNonNull(path);
        try {
            return Files.createDirectories(path, attrs);
        }
        catch (IOException e) {
            throw new KIOException("createDirectories error", (Throwable)e);
        }
    }

    public static Path get(String first, String ... more) {
        return FileSystems.getDefault().getPath(first, more);
    }

    public static Stream<Path> walk(Path start, PathFilter pathFilter, int maxDepth, boolean readAttributes, FileVisitOption ... options) {
        try {
            return Files.walk(start, maxDepth, options).filter(path -> pathFilter.accept((Path)path, readAttributes ? PathUtil.readBasicFileAttributes(path) : null) == FileVisitResult.CONTINUE);
        }
        catch (IOException e) {
            throw new KIOException("walk error", (Throwable)e);
        }
    }

    public static BasicFileAttributes readBasicFileAttributes(Path path) {
        try {
            return Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
        }
        catch (IOException e) {
            throw new KIOException("readBasicFileAttributes error", (Throwable)e);
        }
    }

    public static void delete(Path path, LinkOption[] linkOptions) {
        if (Files.isDirectory(path, linkOptions)) {
            PathUtil.deleteDirectory(path, linkOptions);
        } else {
            PathUtil.deleteFile(path, linkOptions);
        }
    }

    public static boolean deleteFile(Path file, LinkOption[] linkOptions) {
        if (Files.isDirectory(file, linkOptions)) {
            throw new KIOException("invalid file" + file.toString());
        }
        try {
            return Files.deleteIfExists(file);
        }
        catch (IOException e) {
            throw new KIOException("delete file error", (Throwable)e);
        }
    }

    public static void deleteDirectory(Path directory, LinkOption[] linkOptions) {
        PathUtil.visitFileTree(new DeletingPathVisitor(linkOptions), directory);
    }

    public static <T extends FileVisitor<? super Path>> T visitFileTree(T visitor, Path directory) {
        try {
            Files.walkFileTree(directory, visitor);
            return visitor;
        }
        catch (IOException e) {
            throw new KIOException("visitFileTree error", (Throwable)e);
        }
    }

    public static boolean isEmptyDirectory(Path directory) {
        boolean bl;
        block8: {
            DirectoryStream<Path> directoryStream = Files.newDirectoryStream(directory);
            try {
                boolean bl2 = bl = !directoryStream.iterator().hasNext();
                if (directoryStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (directoryStream != null) {
                        try {
                            directoryStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new KIOException("isEmptyDirectory error", (Throwable)e);
                }
            }
            directoryStream.close();
        }
        return bl;
    }
}

