/*
 * Decompiled with CFR 0.152.
 */
package io.github.kylinhunter.commons.io.file.reader;

import io.github.kylinhunter.commons.exception.embed.KIOException;
import io.github.kylinhunter.commons.io.Charsets;
import io.github.kylinhunter.commons.io.IOUtil;
import io.github.kylinhunter.commons.io.file.FileUtil;
import io.github.kylinhunter.commons.io.file.reader.DefaultLineProcessor;
import io.github.kylinhunter.commons.io.file.reader.LineProcessor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;

public class FileReaderUtils {
    public static void process(File file, String encoding, LineProcessor processor) {
        try (InputStream input = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            FileReaderUtils.process(input, encoding, processor);
        }
        catch (Exception e) {
            throw new KIOException("process error", (Throwable)e);
        }
    }

    public static void process(InputStream input, String encoding, LineProcessor processor) {
        try (InputStreamReader streamReader = new InputStreamReader(input, Charsets.toCharset(encoding));
             BufferedReader bufferReader = new BufferedReader(streamReader);){
            String line = bufferReader.readLine();
            while (line != null) {
                processor.process(line);
                line = bufferReader.readLine();
            }
        }
        catch (Exception e) {
            throw new KIOException("process error", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T process(File file, String encoding, DefaultLineProcessor<T> processor) {
        try (InputStream input = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            FileReaderUtils.process(input, encoding, processor);
            T t = processor.getResult();
            return t;
        }
        catch (Exception e) {
            throw new KIOException("process error", (Throwable)e);
        }
    }

    public static byte[] readFileToByteArray(File file) {
        byte[] byArray;
        block8: {
            FileInputStream inputStream = FileUtil.openInputStream(file);
            try {
                long fileLength = file.length();
                byte[] byArray2 = byArray = fileLength > 0L ? IOUtil.toByteArray((InputStream)inputStream, fileLength) : IOUtil.toByteArray(inputStream);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            ((InputStream)inputStream).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new KIOException("readFileToByteArray error", (Throwable)e);
                }
            }
            ((InputStream)inputStream).close();
        }
        return byArray;
    }
}

