/*
 * Decompiled with CFR 0.152.
 */
package io.github.kylinhunter.commons.juc;

import io.github.kylinhunter.commons.collections.MapUtils;
import io.github.kylinhunter.commons.exception.embed.InitException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;

public class ScheduledExecutorFactory {
    private static final Map<String, ScheduledExecutorService> pools = MapUtils.newHashMap();
    private static final int PROCESSORS;
    private static int DEFAULT_CORE_POOL_SIZE;

    public static synchronized ScheduledExecutorService register(String name, int corePoolSize) {
        return pools.computeIfAbsent(name, n -> ScheduledExecutorFactory.create(corePoolSize));
    }

    private static synchronized ScheduledExecutorService create(int corePoolSize) {
        return Executors.newScheduledThreadPool(corePoolSize);
    }

    public static ScheduledExecutorService get(String name) {
        return ScheduledExecutorFactory.get(name, false);
    }

    public static ScheduledExecutorService get(String name, boolean createIfNoExist) {
        ScheduledExecutorService scheduledExecutorService = pools.get(name);
        if (scheduledExecutorService == null) {
            if (createIfNoExist) {
                scheduledExecutorService = ScheduledExecutorFactory.register(name, DEFAULT_CORE_POOL_SIZE);
            } else {
                throw new InitException("no thread pool:" + name);
            }
        }
        return scheduledExecutorService;
    }

    public static List<Runnable> shutdownNow(String name) {
        ScheduledExecutorService threadPoolExecutor = ScheduledExecutorFactory.get(name);
        if (threadPoolExecutor != null) {
            return threadPoolExecutor.shutdownNow();
        }
        return Collections.emptyList();
    }

    static {
        DEFAULT_CORE_POOL_SIZE = PROCESSORS = Runtime.getRuntime().availableProcessors();
    }
}

