/*
 * Decompiled with CFR 0.152.
 */
package io.github.kylinhunter.commons.juc;

import io.github.kylinhunter.commons.collections.MapUtils;
import io.github.kylinhunter.commons.exception.embed.InitException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ThreadPoolExecutorFactory {
    private static final Map<String, ThreadPoolExecutor> pools = MapUtils.newHashMap();
    private static final int PROCESSORS;
    private static int DEFAULT_CORE_POOL_SIZE;
    private static int DEFAULT_MAXIMUM_POOL_SIZE;
    private static int DEFAULT_CAPACITY;

    public static synchronized ThreadPoolExecutor register(String name, int corePoolSize, int maximumPoolSize, int capacity) {
        return pools.computeIfAbsent(name, n -> ThreadPoolExecutorFactory.create(corePoolSize, maximumPoolSize, capacity));
    }

    private static synchronized ThreadPoolExecutor create(int corePoolSize, int maximumPoolSize, int capacity) {
        return new ThreadPoolExecutor(corePoolSize, maximumPoolSize, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(capacity));
    }

    public static ThreadPoolExecutor get(String name) {
        return ThreadPoolExecutorFactory.get(name, false);
    }

    public static ThreadPoolExecutor get(String name, boolean createIfNoExist) {
        ThreadPoolExecutor threadPoolExecutor = pools.get(name);
        if (threadPoolExecutor == null) {
            if (createIfNoExist) {
                threadPoolExecutor = ThreadPoolExecutorFactory.register(name, DEFAULT_CORE_POOL_SIZE, DEFAULT_MAXIMUM_POOL_SIZE, DEFAULT_CAPACITY);
            } else {
                throw new InitException("no thread pool:" + name);
            }
        }
        return threadPoolExecutor;
    }

    public static List<Runnable> shutdownNow(String name) {
        ThreadPoolExecutor threadPoolExecutor = ThreadPoolExecutorFactory.get(name);
        if (threadPoolExecutor != null) {
            return threadPoolExecutor.shutdownNow();
        }
        return Collections.emptyList();
    }

    static {
        DEFAULT_CORE_POOL_SIZE = PROCESSORS = Runtime.getRuntime().availableProcessors();
        DEFAULT_MAXIMUM_POOL_SIZE = PROCESSORS * 2;
        DEFAULT_CAPACITY = Integer.MAX_VALUE;
    }
}

