/*
 * Decompiled with CFR 0.152.
 */
package io.github.kylinhunter.commons.lang;

import io.github.kylinhunter.commons.collections.MapUtils;
import io.github.kylinhunter.commons.exception.embed.ParamException;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;

public class EnumUtils {
    private static final Map<Class<?>, Map<Integer, EnumCode>> ENUM_CODES = new HashMap();
    private static final Map<Class<?>, Map<String, EnumLabel>> ENUM_LABELS = new HashMap();

    public static <V extends EnumLabel> V fromLabel(Class<V> enumType, String label) {
        return EnumUtils.fromLabel(enumType, label, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static <V extends EnumLabel> V fromLabel(Class<V> enumType, String label, boolean throwIfFailed) {
        EnumLabel result = null;
        try {
            Map<String, EnumLabel> enumLabels = ENUM_LABELS.get(enumType);
            if (enumLabels == null) {
                Class<EnumUtils> clazz = EnumUtils.class;
                // MONITORENTER : io.github.kylinhunter.commons.lang.EnumUtils.class
                enumLabels = ENUM_LABELS.get(enumType);
                if (enumLabels == null) {
                    enumLabels = MapUtils.newHashMap();
                    ENUM_LABELS.put(enumType, enumLabels);
                    EnumLabel[] enumConstants = (EnumLabel[])enumType.getEnumConstants();
                    if (enumConstants != null && enumConstants.length > 0) {
                        for (EnumLabel enumConstant : enumConstants) {
                            enumLabels.put(enumConstant.getLabel(), enumConstant);
                        }
                    }
                }
                // MONITOREXIT : clazz
            }
            if ((result = enumLabels.get(label)) != null) return (V)result;
            throw new ParamException("invalid enum label:" + label);
        }
        catch (Exception e) {
            if (!throwIfFailed) return (V)result;
            throw new ParamException("invalid enum label:" + label, (Throwable)e);
        }
    }

    public static <V extends EnumLabel> V[] fromLabel(Class<V> enumType, String[] labels) {
        return EnumUtils.fromLabel(enumType, (String[])labels, (boolean)true);
    }

    public static <V extends EnumLabel> V[] fromLabel(Class<V> enumType, String[] labels, boolean throwIfFailed) {
        if (labels != null && labels.length > 0) {
            EnumLabel[] vs = (EnumLabel[])Array.newInstance(enumType, labels.length);
            for (int i = 0; i < labels.length; ++i) {
                V v = EnumUtils.fromLabel(enumType, labels[i], throwIfFailed);
                if (v == null) {
                    return null;
                }
                vs[i] = v;
            }
            return vs;
        }
        return null;
    }

    public static <V extends EnumCode> V fromCode(Class<V> enumType, int code) {
        return EnumUtils.fromCode(enumType, code, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static <V extends EnumCode> V fromCode(Class<V> enumType, int code, boolean throwIfFailed) {
        EnumCode result = null;
        try {
            Map<Integer, EnumCode> enumCodes = ENUM_CODES.get(enumType);
            if (enumCodes == null) {
                Class<EnumUtils> clazz = EnumUtils.class;
                // MONITORENTER : io.github.kylinhunter.commons.lang.EnumUtils.class
                enumCodes = ENUM_CODES.get(enumType);
                if (enumCodes == null) {
                    enumCodes = MapUtils.newHashMap();
                    ENUM_CODES.put(enumType, enumCodes);
                    EnumCode[] enumConstants = (EnumCode[])enumType.getEnumConstants();
                    if (enumConstants != null && enumConstants.length > 0) {
                        for (EnumCode enumConstant : enumConstants) {
                            enumCodes.put(enumConstant.getCode(), enumConstant);
                        }
                    }
                }
                // MONITOREXIT : clazz
            }
            if ((result = enumCodes.get(code)) != null) return (V)result;
            throw new ParamException("invalid enum code:" + code);
        }
        catch (Exception e) {
            if (!throwIfFailed) return (V)result;
            throw new ParamException("invalid enum code:" + code, (Throwable)e);
        }
    }

    public static <V extends EnumCode> V[] fromCode(Class<V> enumType, int[] codes) {
        return EnumUtils.fromCode(enumType, (int[])codes, (boolean)true);
    }

    public static <V extends EnumCode> V[] fromCode(Class<V> enumType, int[] codes, boolean throwIfFailed) {
        if (codes != null && codes.length > 0) {
            EnumCode[] vs = (EnumCode[])Array.newInstance(enumType, codes.length);
            for (int i = 0; i < codes.length; ++i) {
                V v = EnumUtils.fromCode(enumType, codes[i], throwIfFailed);
                if (v == null) {
                    return null;
                }
                vs[i] = v;
            }
            return vs;
        }
        return null;
    }

    public static <T extends Enum<T>> T fromName(Class<T> enumType, String name) {
        return EnumUtils.fromName(enumType, name, true);
    }

    public static <T extends Enum<T>> T fromName(Class<T> enumType, String name, boolean throwIfFailed) {
        try {
            return Enum.valueOf(enumType, name);
        }
        catch (Exception e) {
            if (throwIfFailed) {
                throw new ParamException("invalid enum name:" + name);
            }
            return null;
        }
    }

    public static <T extends Enum<T>> T[] fromName(Class<T> enumType, String[] names) {
        return EnumUtils.fromName(enumType, (String[])names, (boolean)true);
    }

    public static <T extends Enum<T>> T[] fromName(Class<T> enumType, String[] names, boolean throwIfFailed) {
        if (names != null && names.length > 0) {
            Enum[] ts = (Enum[])Array.newInstance(enumType, names.length);
            for (int i = 0; i < names.length; ++i) {
                T t = EnumUtils.fromName(enumType, names[i], throwIfFailed);
                if (t == null) {
                    return null;
                }
                ts[i] = t;
            }
            return ts;
        }
        return null;
    }

    public static interface EnumLabel {
        public String getLabel();
    }

    public static interface EnumCode {
        public int getCode();
    }
}

