/*
 * Decompiled with CFR 0.152.
 */
package io.github.kylinhunter.commons.log.jul;

import io.github.kylinhunter.commons.exception.embed.GeneralException;
import io.github.kylinhunter.commons.io.ResourceHelper;
import io.github.kylinhunter.commons.lang.strings.StringUtil;
import io.github.kylinhunter.commons.reflect.ClassUtil;
import io.github.kylinhunter.commons.reflect.ReflectUtils;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.Properties;
import java.util.logging.LogManager;

public class JULManager {
    private static volatile Boolean initialized;
    private static final String DEFAULT_CONFIG_FILE = "k-jul-logging.properties";

    public static boolean init() {
        return JULManager.init(DEFAULT_CONFIG_FILE, true);
    }

    public static boolean init(boolean slf4jSupported) {
        return JULManager.init(DEFAULT_CONFIG_FILE, slf4jSupported);
    }

    public static boolean init(String configFile) {
        return JULManager.init(configFile, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized boolean init(String configFile, boolean slf4jSupported) {
        if (initialized != null) {
            return initialized;
        }
        Class<JULManager> clazz = JULManager.class;
        synchronized (JULManager.class) {
            if (initialized != null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return initialized;
            }
            try {
                if (StringUtil.isEmpty(configFile)) {
                    configFile = DEFAULT_CONFIG_FILE;
                }
                JULManager.readConfiguration(configFile);
                if (slf4jSupported) {
                    JULManager.trySlf4jSupport(configFile);
                }
                initialized = true;
            }
            catch (Exception e) {
                System.err.println("init error:" + e.getMessage());
                initialized = false;
            }
            return initialized;
        }
    }

    private static void readConfiguration(String configFile) {
        try (InputStream inputStream = ResourceHelper.getInputStreamInClassPath(configFile);){
            LogManager logManager = LogManager.getLogManager();
            logManager.readConfiguration(inputStream);
        }
        catch (Exception e) {
            throw new GeneralException("read " + configFile + "error:" + e.getMessage());
        }
    }

    private static Properties readProperties(String configFile) {
        Properties properties;
        block8: {
            InputStream inputStream = ResourceHelper.getInputStreamInClassPath(configFile);
            try {
                Properties properties2 = new Properties();
                properties2.load(inputStream);
                properties = properties2;
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    System.err.println("read readProperties error" + e.getMessage());
                    return null;
                }
            }
            inputStream.close();
        }
        return properties;
    }

    public static void trySlf4jSupport(String configFile) {
        Properties properties = JULManager.readProperties(configFile);
        Objects.requireNonNull(properties);
        String handlers = properties.getProperty("handlers");
        if (StringUtil.isEmpty(handlers) || !handlers.contains("SLF4J")) {
            JULManager.trySlf4jSupport();
        }
    }

    public static void trySlf4jSupport() {
        Class clazz = ClassUtil.findClass("org.slf4j.bridge.SLF4JBridgeHandler");
        if (clazz != null) {
            Method methodRemoveHandlersForRootLogger = ReflectUtils.getMethod(clazz, "removeHandlersForRootLogger", new Class[0]);
            ReflectUtils.invoke(null, methodRemoveHandlersForRootLogger, new Object[0]);
            Method methodInstall = ReflectUtils.getMethod(clazz, "install", new Class[0]);
            ReflectUtils.invoke(null, methodInstall, new Object[0]);
        }
    }

    public static void reset() {
        initialized = null;
    }
}

