/*
 * Decompiled with CFR 0.152.
 */
package io.github.kylinhunter.commons.name;

import io.github.kylinhunter.commons.lang.strings.StringUtil;
import io.github.kylinhunter.commons.name.SnakeFormat;
import io.github.kylinhunter.commons.name.SnakeToCamelUtils;
import lombok.Generated;

public class CamelToSnakeUtils {
    public static String convert(String name) {
        return CamelToSnakeUtils.convert(name, SnakeFormat.LOWWER_UNDERSCORE);
    }

    public static String convert(String name, SnakeFormat snakeFormat) {
        if (StringUtil.isBlank(name)) {
            return "";
        }
        if (SnakeToCamelUtils.isSnake(name)) {
            return name;
        }
        if (snakeFormat == null) {
            snakeFormat = SnakeFormat.LOWWER_UNDERSCORE;
        }
        int len = name.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = name.charAt(i);
            if (Character.isUpperCase(c) && i > 0) {
                sb.append(snakeFormat.seperator);
            }
            if (snakeFormat.lower) {
                sb.append(Character.toLowerCase(c));
                continue;
            }
            sb.append(Character.toUpperCase(c));
        }
        return sb.toString();
    }

    @Generated
    public CamelToSnakeUtils() {
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CamelToSnakeUtils)) {
            return false;
        }
        CamelToSnakeUtils other = (CamelToSnakeUtils)o;
        return other.canEqual(this);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CamelToSnakeUtils;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Generated
    public String toString() {
        return "CamelToSnakeUtils()";
    }
}

