/*
 * Decompiled with CFR 0.152.
 */
package io.github.kylinhunter.commons.name;

import io.github.kylinhunter.commons.exception.embed.ParamException;
import io.github.kylinhunter.commons.lang.strings.StringUtil;
import io.github.kylinhunter.commons.name.CamelFormat;
import io.github.kylinhunter.commons.name.CamelToSnakeUtils;
import io.github.kylinhunter.commons.name.NamePair;
import io.github.kylinhunter.commons.name.NameRule;
import io.github.kylinhunter.commons.name.SnakeFormat;
import io.github.kylinhunter.commons.name.SnakeToCamelUtils;

public class NameUtils {
    public static NamePair toNamePair(String str) {
        return NameUtils.toNamePair(str, CamelFormat.LOWER, SnakeFormat.LOWWER_UNDERSCORE);
    }

    public static NamePair toNamePair(String str, CamelFormat camelFormat) {
        return NameUtils.toNamePair(str, camelFormat, SnakeFormat.LOWWER_UNDERSCORE);
    }

    public static NamePair toNamePair(String str, SnakeFormat snakeFormat) {
        return NameUtils.toNamePair(str, CamelFormat.LOWER, snakeFormat);
    }

    public static NamePair toNamePair(String str, CamelFormat camelFormat, SnakeFormat snakeFormat) {
        if (!StringUtil.isEmpty(str)) {
            NamePair namePair = new NamePair();
            if (SnakeToCamelUtils.isSnake(str)) {
                namePair.setSnake(str);
                namePair.setCamel(SnakeToCamelUtils.convert(str, camelFormat));
            } else {
                namePair.setCamel(str);
                namePair.setSnake(CamelToSnakeUtils.convert(str, snakeFormat));
            }
            return namePair;
        }
        throw new ParamException("str is emtpty");
    }

    public static String convert(String name, NameRule nameRule) {
        if (nameRule.isCamel()) {
            return SnakeToCamelUtils.convert(name, nameRule.getCamelFormat());
        }
        return CamelToSnakeUtils.convert(name, nameRule.getSnakeFormat());
    }
}

