/*
 * Decompiled with CFR 0.152.
 */
package io.github.kylinhunter.commons.name;

import io.github.kylinhunter.commons.lang.strings.StringUtil;
import io.github.kylinhunter.commons.name.CamelFormat;
import java.util.Arrays;
import lombok.Generated;

public class SnakeToCamelUtils {
    public static String convert(String name) {
        return SnakeToCamelUtils.convert(name, CamelFormat.LOWER);
    }

    public static String convert(String name, CamelFormat camelFormat) {
        if (StringUtil.isBlank((CharSequence)name)) {
            return "";
        }
        if (!SnakeToCamelUtils.isSnake((String)name)) {
            name = camelFormat == CamelFormat.LOWER ? Character.toLowerCase(((String)name).charAt(0)) + ((String)name).substring(1) : Character.toUpperCase(((String)name).charAt(0)) + ((String)name).substring(1);
            return name;
        }
        StringBuilder result = new StringBuilder();
        char sep = ((String)name).indexOf("_") > 0 ? (char)'_' : '-';
        String[] camels = ((String)name).split("" + sep);
        Arrays.stream(camels).filter(camel -> !StringUtil.isBlank(camel)).forEach(camel -> result.append(Character.toUpperCase(camel.charAt(0))).append(camel.substring(1).toLowerCase()));
        if (camelFormat == CamelFormat.LOWER) {
            result.setCharAt(0, Character.toLowerCase(result.charAt(0)));
        }
        return result.toString();
    }

    public static boolean isSnake(String name) {
        return name.indexOf(95) > 0 || name.indexOf(45) > 0;
    }

    @Generated
    public SnakeToCamelUtils() {
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SnakeToCamelUtils)) {
            return false;
        }
        SnakeToCamelUtils other = (SnakeToCamelUtils)o;
        return other.canEqual(this);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SnakeToCamelUtils;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Generated
    public String toString() {
        return "SnakeToCamelUtils()";
    }
}

