/*
 * Decompiled with CFR 0.152.
 */
package io.github.kylinhunter.commons.reflect;

import io.github.kylinhunter.commons.collections.ArrayUtils;
import io.github.kylinhunter.commons.collections.CollectionUtils;
import io.github.kylinhunter.commons.collections.MapUtils;
import io.github.kylinhunter.commons.collections.SetUtils;
import io.github.kylinhunter.commons.exception.wrapper.ExceptionWrapper;
import io.github.kylinhunter.commons.reflect.Interfaces;
import io.github.kylinhunter.commons.reflect.SuperClazzes;
import java.lang.reflect.Constructor;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Constructors {
    private static final Map<Class<?>, Set<Constructor<?>>> CACHE_GET = MapUtils.newHashMap();
    private static final Map<Class<?>, Set<Constructor<?>>> CACHE_GET_ALL = MapUtils.newHashMap();

    @SafeVarargs
    public static Set<Constructor<?>> get(Class<?> clazz, Predicate<Constructor<?>> ... predicates) {
        Set result = CACHE_GET.computeIfAbsent(clazz, c -> Stream.of(c.getDeclaredConstructors()).collect(Collectors.toCollection(LinkedHashSet::new)));
        if (!CollectionUtils.isEmpty(result) && !ArrayUtils.isEmpty(predicates)) {
            return CollectionUtils.andFilter(result, LinkedHashSet::new, predicates);
        }
        return result;
    }

    @SafeVarargs
    public static Set<Constructor<?>> getAll(Class<?> clazz, Predicate<Constructor<?>> ... predicates) {
        Set result = CACHE_GET_ALL.computeIfAbsent(clazz, c -> {
            HashSet<Constructor<?>> tmpResult = SetUtils.newHashSet();
            tmpResult.addAll(Constructors.get(clazz, new Predicate[0]));
            SuperClazzes.getAll(clazz, new Predicate[0]).forEach(superclazz -> tmpResult.addAll(Constructors.get(superclazz, new Predicate[0])));
            Interfaces.getAll(clazz, new Predicate[0]).forEach(i -> tmpResult.addAll(Constructors.get(i, new Predicate[0])));
            return tmpResult;
        });
        if (!CollectionUtils.isEmpty(result) && !ArrayUtils.isEmpty(predicates)) {
            return CollectionUtils.andFilter(result, LinkedHashSet::new, predicates);
        }
        return result;
    }

    @ExceptionWrapper
    public static <T> Constructor<T> getConstructor(Class<T> clazz, Class<?> ... parameterTypes) {
        return clazz.getConstructor(parameterTypes);
    }
}

