/*
 * Decompiled with CFR 0.152.
 */
package io.github.kylinhunter.commons.reflect;

import io.github.kylinhunter.commons.collections.ArrayUtils;
import io.github.kylinhunter.commons.collections.CollectionUtils;
import io.github.kylinhunter.commons.collections.MapUtils;
import io.github.kylinhunter.commons.collections.SetUtils;
import io.github.kylinhunter.commons.reflect.Interfaces;
import io.github.kylinhunter.commons.reflect.SuperClazzes;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Fields {
    private static final Map<Class<?>, Set<Field>> CACHE_GET = MapUtils.newHashMap();
    private static final Map<Class<?>, Set<Field>> CACHE_GET_ALL = MapUtils.newHashMap();

    @SafeVarargs
    public static Set<Field> get(Class<?> clazz, Predicate<Field> ... predicates) {
        Set result = CACHE_GET.computeIfAbsent(clazz, c -> Stream.of(c.getDeclaredFields()).collect(Collectors.toCollection(LinkedHashSet::new)));
        if (!CollectionUtils.isEmpty(result) && !ArrayUtils.isEmpty(predicates)) {
            return CollectionUtils.andFilter(result, LinkedHashSet::new, predicates);
        }
        return result;
    }

    @SafeVarargs
    public static Set<Field> getAll(Class<?> clazz, Predicate<Field> ... predicates) {
        Set result = CACHE_GET_ALL.computeIfAbsent(clazz, c -> {
            HashSet<Field> tmpResult = SetUtils.newHashSet();
            tmpResult.addAll(Fields.get(clazz, new Predicate[0]));
            SuperClazzes.getAll(clazz, new Predicate[0]).forEach(superclazz -> tmpResult.addAll(Fields.get(superclazz, new Predicate[0])));
            Interfaces.getAll(clazz, new Predicate[0]).forEach(i -> tmpResult.addAll(Fields.get(i, new Predicate[0])));
            return tmpResult;
        });
        if (!CollectionUtils.isEmpty(result) && !ArrayUtils.isEmpty(predicates)) {
            return CollectionUtils.andFilter(result, LinkedHashSet::new, predicates);
        }
        return result;
    }
}

