/*
 * Decompiled with CFR 0.152.
 */
package io.github.kylinhunter.commons.reflect;

import io.github.kylinhunter.commons.reflect.bean.ActualType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public class GenericTypeUtils {
    private static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final ActualType[] EMPTY_ACTUAL_TYPE = new ActualType[0];

    public static ActualType getSuperClassActualType(Class<?> clazz) {
        return GenericTypeUtils.getActualType(clazz.getGenericSuperclass());
    }

    public static <T> Class<T> getSuperClassActualType(Class<?> clazz, int index) {
        ActualType actualType = GenericTypeUtils.getActualType(clazz.getGenericSuperclass());
        if (actualType != null) {
            return actualType.getType(index);
        }
        return null;
    }

    public static ActualType[] getInterfaceActualTypes(Class<?> clazz) {
        return GenericTypeUtils.getActualTypes(clazz.getGenericInterfaces());
    }

    public static ActualType getInterfaceActualType(Class<?> clazz, int interfaceIndex) {
        ActualType[] actualTypes = GenericTypeUtils.getInterfaceActualTypes(clazz);
        if (interfaceIndex >= 0 && interfaceIndex < actualTypes.length) {
            return actualTypes[interfaceIndex];
        }
        return null;
    }

    public static <T> Class<T> getInterfaceActualType(Class<?> clazz, int interfaceIndex, int typeIndex) {
        ActualType[] actualTypes = GenericTypeUtils.getInterfaceActualTypes(clazz);
        if (interfaceIndex >= 0 && interfaceIndex < actualTypes.length) {
            ActualType actualType = actualTypes[interfaceIndex];
            return actualType.getType(typeIndex);
        }
        return null;
    }

    public static ActualType getMethodReturnActualType(Method method) {
        return GenericTypeUtils.getActualType(method.getGenericReturnType());
    }

    public static <T> Class<T> getMethodReturnActualType(Method method, int index) {
        ActualType actualType = GenericTypeUtils.getActualType(method.getGenericReturnType());
        if (actualType != null) {
            return actualType.getType(index);
        }
        return null;
    }

    public static ActualType[] getMethodParamterActualType(Method method) {
        return GenericTypeUtils.getActualTypes(method.getGenericParameterTypes());
    }

    public static ActualType getMethodParamterActualType(Method method, int paramterIndex) {
        ActualType[] interfacesActualTypes = GenericTypeUtils.getMethodParamterActualType(method);
        if (paramterIndex >= 0 && paramterIndex < interfacesActualTypes.length) {
            return interfacesActualTypes[paramterIndex];
        }
        return null;
    }

    public static <T> Class<T> getMethodParamterActualType(Method method, int paramterIndex, int typeIndex) {
        ActualType[] actualTypes = GenericTypeUtils.getMethodParamterActualType(method);
        if (paramterIndex >= 0 && paramterIndex < actualTypes.length) {
            ActualType interfacesActualType = actualTypes[paramterIndex];
            return interfacesActualType.getType(typeIndex);
        }
        return null;
    }

    public static Class<?>[] getActualTypeArguments(Type type) {
        ActualType actualType = GenericTypeUtils.getActualType(type);
        if (actualType != null) {
            return actualType.getTypes();
        }
        return EMPTY_CLASS_ARRAY;
    }

    public static <T> Class<T> getActualTypeArgument(Type type, int index) {
        ActualType actualType = GenericTypeUtils.getActualType(type);
        if (actualType != null) {
            return actualType.getType(index);
        }
        return null;
    }

    private static ActualType[] getActualTypes(Type[] types) {
        if (types.length > 0) {
            ActualType[] actualTypes = new ActualType[types.length];
            for (int i = 0; i < types.length; ++i) {
                actualTypes[i] = GenericTypeUtils.getActualType(types[i]);
            }
            return actualTypes;
        }
        return EMPTY_ACTUAL_TYPE;
    }

    private static ActualType getActualType(Type type) {
        ParameterizedType parameterizedType;
        if (type instanceof ParameterizedType && (parameterizedType = (ParameterizedType)type).getRawType() instanceof Class) {
            Class rawType = (Class)parameterizedType.getRawType();
            Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
            if (actualTypeArguments != null && actualTypeArguments.length > 0) {
                Class[] clazzes = new Class[actualTypeArguments.length];
                for (int i = 0; i < actualTypeArguments.length; ++i) {
                    Type actualTypeArgument = actualTypeArguments[i];
                    clazzes[i] = actualTypeArgument instanceof Class ? (Class)actualTypeArgument : null;
                }
                return new ActualType(rawType, clazzes);
            }
        }
        return null;
    }
}

