/*
 * Decompiled with CFR 0.152.
 */
package io.github.kylinhunter.commons.reflect;

import io.github.kylinhunter.commons.collections.ArrayUtils;
import io.github.kylinhunter.commons.collections.CollectionUtils;
import io.github.kylinhunter.commons.collections.MapUtils;
import io.github.kylinhunter.commons.collections.SetUtils;
import io.github.kylinhunter.commons.reflect.SuperClazzes;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Interfaces {
    private static final Map<Class<?>, Set<Class<?>>> CACHE_GET = MapUtils.newHashMap();
    private static final Map<Class<?>, Set<Class<?>>> CACHE_GET_ALL = MapUtils.newHashMap();

    @SafeVarargs
    public static Set<Class<?>> get(Class<?> clazz, Predicate<Class<?>> ... predicates) {
        Set result = CACHE_GET.computeIfAbsent(clazz, c -> Stream.of(c.getInterfaces()).collect(Collectors.toCollection(LinkedHashSet::new)));
        if (!CollectionUtils.isEmpty(result) && !ArrayUtils.isEmpty(predicates)) {
            return CollectionUtils.andFilter(result, LinkedHashSet::new, predicates);
        }
        return result;
    }

    @SafeVarargs
    public static Set<Class<?>> getAll(Class<?> clazz, Predicate<Class<?>> ... predicates) {
        Set result = CACHE_GET_ALL.computeIfAbsent(clazz, c -> {
            HashSet<Class> tmpResult = SetUtils.newHashSet();
            LinkedList queue = new LinkedList(Interfaces.get(clazz, new Predicate[0]));
            SuperClazzes.getAll(clazz, new Predicate[0]).forEach(superclazz -> queue.addAll(Interfaces.get(superclazz, new Predicate[0])));
            while (!queue.isEmpty()) {
                Class removeInterface = (Class)queue.remove();
                tmpResult.add(removeInterface);
                Object[] superInterfaces = removeInterface.getInterfaces();
                if (ArrayUtils.isEmpty(superInterfaces)) continue;
                Collections.addAll(queue, superInterfaces);
            }
            return tmpResult;
        });
        if (!CollectionUtils.isEmpty(result) && !ArrayUtils.isEmpty(predicates)) {
            return CollectionUtils.andFilter(result, LinkedHashSet::new, predicates);
        }
        return result;
    }
}

