/*
 * Decompiled with CFR 0.152.
 */
package io.github.kylinhunter.commons.reflect;

import io.github.kylinhunter.commons.collections.ArrayUtils;
import io.github.kylinhunter.commons.collections.CollectionUtils;
import io.github.kylinhunter.commons.collections.MapUtils;
import io.github.kylinhunter.commons.collections.SetUtils;
import io.github.kylinhunter.commons.reflect.Interfaces;
import io.github.kylinhunter.commons.reflect.SuperClazzes;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Methods {
    private static final Map<Class<?>, Set<Method>> CACHE_GET = MapUtils.newHashMap();
    private static final Map<Class<?>, Set<Method>> CACHE_GET_ALL = MapUtils.newHashMap();

    @SafeVarargs
    public static Set<Method> get(Class<?> clazz, Predicate<Method> ... predicates) {
        Set result = CACHE_GET.computeIfAbsent(clazz, c -> Stream.of(c.getDeclaredMethods()).collect(Collectors.toCollection(LinkedHashSet::new)));
        if (!CollectionUtils.isEmpty(result) && !ArrayUtils.isEmpty(predicates)) {
            return CollectionUtils.andFilter(result, LinkedHashSet::new, predicates);
        }
        return result;
    }

    @SafeVarargs
    public static Set<Method> getAll(Class<?> clazz, Predicate<Method> ... predicates) {
        Set result = CACHE_GET_ALL.computeIfAbsent(clazz, c -> {
            HashSet<Method> tmpResult = SetUtils.newHashSet();
            tmpResult.addAll(Methods.get(clazz, new Predicate[0]));
            SuperClazzes.getAll(clazz, new Predicate[0]).forEach(superclazz -> tmpResult.addAll(Methods.get(superclazz, new Predicate[0])));
            Interfaces.getAll(clazz, new Predicate[0]).forEach(i -> tmpResult.addAll(Methods.get(i, new Predicate[0])));
            return tmpResult;
        });
        if (!CollectionUtils.isEmpty(result) && !ArrayUtils.isEmpty(predicates)) {
            return CollectionUtils.andFilter(result, LinkedHashSet::new, predicates);
        }
        return result;
    }
}

