/*
 * Decompiled with CFR 0.152.
 */
package io.github.kylinhunter.commons.reflect;

import io.github.kylinhunter.commons.exception.embed.InitException;
import io.github.kylinhunter.commons.reflect.Constructors;
import io.github.kylinhunter.commons.reflect.Fields;
import io.github.kylinhunter.commons.reflect.Interfaces;
import io.github.kylinhunter.commons.reflect.Methods;
import io.github.kylinhunter.commons.reflect.SuperClazzes;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Set;
import java.util.function.Predicate;

public class ReflectUtils {
    public static <T> T invoke(Object obj, Method method, Object ... args) {
        try {
            method.setAccessible(true);
            return (T)method.invoke(obj, args);
        }
        catch (Exception e) {
            throw new InitException("invoke error: " + method, (Throwable)e);
        }
    }

    public static Object get(Object obj, Field field) {
        try {
            field.setAccessible(true);
            return field.get(obj);
        }
        catch (Exception e) {
            throw new InitException("invoke error", (Throwable)e);
        }
    }

    public static Class<?> getSuperClass(Class<?> clazz) {
        return SuperClazzes.get(clazz);
    }

    @SafeVarargs
    public static Set<Class<?>> getAllSuperClasses(Class<?> clazz, Predicate<Class<?>> ... predicates) {
        return SuperClazzes.getAll(clazz, predicates);
    }

    @SafeVarargs
    public static Set<Class<?>> getInterfaces(Class<?> clazz, Predicate<Class<?>> ... predicates) {
        return Interfaces.get(clazz, predicates);
    }

    @SafeVarargs
    public static Set<Class<?>> getAllInterfaces(Class<?> clazz, Predicate<Class<?>> ... predicates) {
        return Interfaces.getAll(clazz, predicates);
    }

    @SafeVarargs
    public static Set<Method> getMethods(Class<?> clazz, Predicate<Method> ... predicates) {
        return Methods.get(clazz, predicates);
    }

    public static Method getMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) {
        try {
            return clazz.getMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    @SafeVarargs
    public static Set<Method> getAllMethods(Class<?> clazz, Predicate<Method> ... predicates) {
        return Methods.getAll(clazz, predicates);
    }

    @SafeVarargs
    public static Set<Constructor<?>> getConstructors(Class<?> clazz, Predicate<Constructor<?>> ... predicates) {
        return Constructors.get(clazz, predicates);
    }

    @SafeVarargs
    public static Set<Constructor<?>> getAllConstructors(Class<?> clazz, Predicate<Constructor<?>> ... predicates) {
        return Constructors.getAll(clazz, predicates);
    }

    @SafeVarargs
    public static Set<Field> getFields(Class<?> clazz, Predicate<Field> ... predicates) {
        return Fields.get(clazz, predicates);
    }

    public static Field getField(Class<?> clazz, String name) {
        try {
            return ReflectUtils.getAllFields(clazz, new Predicate[0]).stream().filter(field -> name.equals(field.getName())).findFirst().orElse(null);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @SafeVarargs
    public static Set<Field> getAllFields(Class<?> clazz, Predicate<Field> ... predicates) {
        return Fields.getAll(clazz, predicates);
    }

    public static void setField(Object obj, String fieldName, Object value) {
        try {
            Field field = ReflectUtils.getField(obj.getClass(), fieldName);
            ReflectUtils.setField(obj, field, value);
        }
        catch (Exception e) {
            throw new InitException("invoke error", (Throwable)e);
        }
    }

    public static void setField(Object obj, Field field, Object value) {
        try {
            if (!field.canAccess(obj)) {
                field.setAccessible(true);
            }
            field.set(obj, value);
        }
        catch (Exception e) {
            throw new InitException("invoke error", (Throwable)e);
        }
    }
}

