/*
 * Decompiled with CFR 0.152.
 */
package io.github.kylinhunter.commons.reflect;

import io.github.kylinhunter.commons.collections.ArrayUtils;
import io.github.kylinhunter.commons.collections.CollectionUtils;
import io.github.kylinhunter.commons.collections.MapUtils;
import io.github.kylinhunter.commons.collections.SetUtils;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;

public class SuperClazzes {
    private static final Map<Class<?>, Set<Class<?>>> CACHE_GET_ALL = MapUtils.newHashMap();

    public static Class<?> get(Class<?> clazz) {
        Class<?> superclass = clazz.getSuperclass();
        return superclass != null && !superclass.equals(Object.class) ? superclass : null;
    }

    @SafeVarargs
    public static Set<Class<?>> getAll(Class<?> clazz, Predicate<Class<?>> ... predicates) {
        Set result = CACHE_GET_ALL.computeIfAbsent(clazz, c -> {
            HashSet tmpResult = SetUtils.newHashSet();
            for (Class superclass = c.getSuperclass(); superclass != null && !superclass.equals(Object.class); superclass = superclass.getSuperclass()) {
                tmpResult.add(superclass);
            }
            return tmpResult;
        });
        if (!CollectionUtils.isEmpty(result) && !ArrayUtils.isEmpty(predicates)) {
            return CollectionUtils.andFilter(result, LinkedHashSet::new, predicates);
        }
        return result;
    }
}

