/*
 * Decompiled with CFR 0.152.
 */
package io.github.kylinhunter.commons.serialize;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.github.kylinhunter.commons.exception.check.ThrowChecker;
import io.github.kylinhunter.commons.exception.embed.InternalException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Base64;

public class ObjectBytesSerializer {
    /*
     * Enabled aggressive exception aggregation
     */
    public static byte[] serialize(Object obj) {
        ThrowChecker.checkNotNull(obj, "obj can't be null");
        try (ByteArrayOutputStream bao = new ByteArrayOutputStream();){
            byte[] byArray;
            try (ObjectOutputStream oo = new ObjectOutputStream(bao);){
                oo.writeObject(obj);
                byArray = bao.toByteArray();
            }
            return byArray;
        }
        catch (Exception e) {
            throw new InternalException("convert error", (Throwable)e);
        }
    }

    public static String serializeToString(Object obj) {
        byte[] serialize = ObjectBytesSerializer.serialize(obj);
        byte[] bytes = Base64.getEncoder().encode(serialize);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @SuppressFBWarnings(value={"OBJECT_DESERIALIZATION"})
    public static <T> T deserialize(byte[] bytes) {
        ThrowChecker.checkArgument(bytes != null && bytes.length > 0, "obj can't be empty");
        try (ByteArrayInputStream bai = new ByteArrayInputStream(bytes);){
            Object object;
            try (ObjectInputStream in = new ObjectInputStream(bai);){
                object = in.readObject();
            }
            return (T)object;
        }
        catch (Exception e) {
            throw new InternalException("convert error", (Throwable)e);
        }
    }

    public static <T> T deserialize(String text) {
        byte[] bytes = Base64.getDecoder().decode(text.getBytes(StandardCharsets.UTF_8));
        return ObjectBytesSerializer.deserialize(bytes);
    }
}

