/*
 * Decompiled with CFR 0.152.
 */
package io.github.kylinhunter.commons.state;

import io.github.kylinhunter.commons.exception.embed.InitException;
import io.github.kylinhunter.commons.reflect.GenericTypeUtils;
import java.util.Arrays;
import java.util.StringJoiner;
import lombok.Generated;

public abstract class AbstractBitState<E extends Enum<E>> {
    private long[] bitStates;

    public AbstractBitState() {
        Enum[] enumConstants;
        Class genericType = GenericTypeUtils.getActualTypeArgument(this.getClass().getGenericSuperclass(), 0);
        if (genericType == null) {
            throw new InitException("genericType can't be null");
        }
        if (Enum.class.isAssignableFrom(genericType)) {
            enumConstants = (Enum[])genericType.getEnumConstants();
            if (enumConstants.length <= 0) {
                throw new InitException("enum size is empty");
            }
        } else {
            throw new InitException("genericType not a instance of Enum");
        }
        this.bitStates = new long[(enumConstants.length - 1) / 64 + 1];
    }

    @SafeVarargs
    public final void setState(E ... states) {
        for (E status : states) {
            int ordinal = ((Enum)status).ordinal();
            int remainder = ordinal % 64;
            int n = ordinal / 64;
            this.bitStates[n] = this.bitStates[n] | 1L << remainder;
        }
    }

    @SafeVarargs
    public final void removeState(E ... states) {
        for (E status : states) {
            int ordinal = ((Enum)status).ordinal();
            int remainder = ordinal % 64;
            int n = ordinal / 64;
            this.bitStates[n] = this.bitStates[n] & (1L << remainder ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    @SafeVarargs
    public final boolean hasState(E ... states) {
        for (E status : states) {
            int remainder;
            int ordinal = ((Enum)status).ordinal();
            if ((this.bitStates[ordinal / 64] & 1L << (remainder = ordinal % 64)) == 0L) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(", ", AbstractBitState.class.getSimpleName() + "[", "]");
        for (int i = 0; i < this.bitStates.length; ++i) {
            joiner.add("bitStates[" + i + "]=" + Long.toBinaryString(this.bitStates[i]));
        }
        return joiner.toString();
    }

    @Generated
    public long[] getBitStates() {
        return this.bitStates;
    }

    @Generated
    public void setBitStates(long[] bitStates) {
        this.bitStates = bitStates;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractBitState)) {
            return false;
        }
        AbstractBitState other = (AbstractBitState)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Arrays.equals(this.getBitStates(), other.getBitStates());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AbstractBitState;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.getBitStates());
        return result;
    }
}

