/*
 * Decompiled with CFR 0.152.
 */
package io.github.kylinhunter.commons.tools;

import java.util.StringJoiner;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import lombok.Generated;

public class WeakPasswordChecker {
    public static final Logger log = Logger.getLogger(WeakPasswordChecker.class.toString());
    private Pattern PATTERN_BASIC;
    private Pattern PATTERN_DUPLICATE_CHARACTER;
    private Pattern PATTERN_CONTINUOUS_NUMBER_ASC;
    private Pattern PATTERN_CONTINUOUS_NUMBER_DESC;
    private Pattern PATTERN_CONTINUOUS_ENGLISH_ALPHABET_ASC;
    private Pattern PATTERN_CONTINUOUS_ENGLISH_ALPHABET_DESC;
    private Pattern PATTERN_KEYBOARD_HORIZONTAL_CONTINUOUS_CHARS;
    private Pattern PATTERN_KEYBOARD_VERTICAL_CONTINUOUS_CHARS;
    private WeakPassOption option;

    public WeakPasswordChecker() {
        this(WeakPassOption.builder().build());
    }

    public WeakPasswordChecker(WeakPassOption option) {
        StringJoiner stringJoiner = new StringJoiner("", "^", "$");
        stringJoiner.add("(?=.*[a-z])");
        if (option.containSpecialUppercaseLetter) {
            stringJoiner.add("(?=.*[A-Z])");
        }
        if (option.containSpecialNumbers) {
            stringJoiner.add("(?=.*\\d)");
        }
        if (option.containSpecialCharacters) {
            stringJoiner.add("(?=.*[@#$!%*?&])");
        }
        stringJoiner.add("[A-Za-z\\d@#$!%*?&]{" + option.getMinLength() + "," + option.getMaxLength() + "}");
        this.PATTERN_BASIC = Pattern.compile(stringJoiner.toString());
        this.PATTERN_DUPLICATE_CHARACTER = Pattern.compile("([0-9a-zA-Z])\\1{" + (option.getMinDuplicateChars() - 1) + "}");
        this.PATTERN_CONTINUOUS_NUMBER_ASC = Pattern.compile("(?:0(?=1)|1(?=2)|2(?=3)|3(?=4)|4(?=5)|5(?=6)|6(?=7)|7(?=8)|8(?=9)){" + (option.getMinContinuousChars() - 1) + "}");
        this.PATTERN_CONTINUOUS_NUMBER_DESC = Pattern.compile("(?:9(?=8)|8(?=7)|7(?=6)|6(?=5)|5(?=4)|4(?=3)|3(?=2)|2(?=1)|1(?=0)){" + (option.getMinContinuousChars() - 1) + "}");
        this.PATTERN_CONTINUOUS_ENGLISH_ALPHABET_ASC = Pattern.compile("(?:a(?=b)|b(?=c)|c(?=d)|d(?=e)|e(?=f)|f(?=g)|g(?=h)|h(?=i)|i(?=j)|j(?=k)|k(?=l)|l(?=m)|m(?=n)|n(?=o)|o(?=p)|p(?=q)|q(?=r)|r(?=s)|s(?=t)|t(?=u)|u(?=v)|v(?=w)|w(?=x)|x(?=y)|y(?=z)){" + (option.getMinContinuousChars() - 1) + "}");
        this.PATTERN_CONTINUOUS_ENGLISH_ALPHABET_DESC = Pattern.compile("(?:z(?=y)|y(?=x)|x(?=w)|w(?=v)|v(?=u)|u(?=t)|t(?=s)|s(?=r)|r(?=q)|q(?=p)|p(?=o)|o(?=n)|n(?=m)|m(?=l)|l(?=k)|k(?=j)|j(?=i)|i(?=h)|h(?=g)|g(?=f)|f(?=e)|e(?=d)|d(?=c)|c(?=b)|b(?=a)){" + (option.getMinContinuousChars() - 1) + "}");
        this.PATTERN_KEYBOARD_HORIZONTAL_CONTINUOUS_CHARS = Pattern.compile("(?:q(?=w)|w(?=e)|e(?=r)|r(?=t)|t(?=y)|y(?=u)|u(?=i)|i(?=o)|o(?=p)|a(?=s)|s(?=d)|d(?=f)|f(?=g)|g(?=h)|h(?=j)|j(?=k)|k(?=l)|z(?=x)|x(?=c)|c(?=v)|v(?=b)|b(?=n)|n(?=m)){" + (option.getMinContinuousChars() - 1) + "}");
        this.PATTERN_KEYBOARD_VERTICAL_CONTINUOUS_CHARS = Pattern.compile("(?:1(?=q)|q(?=a)|a(?=z)|2(?=w)|w(?=s)|s(?=x)|3(?=e)e(?=d)|d(?=c)|4(?=r)|r(?=f)|f(?=v)|5(?=t)|t(?=g)|g(?=b)|6(?=y)|y(?=h)|h(?=n)|7(?=u)|u(?=j)|j(?=m)|8(?=i)|i(?=k)|k(?=,)|9(?=o)|o(?=l)|l(?=.)|0(?=p)|p(?=;)|;(?=/)){" + (option.getMinContinuousChars() - 1) + "}");
        this.option = option;
    }

    public boolean check(String password) {
        if (this.PATTERN_BASIC.matcher(password).matches()) {
            boolean isWeak;
            boolean bl = isWeak = this.option.enableDuplicateCheck && this.PATTERN_DUPLICATE_CHARACTER.matcher(password).find();
            if (!isWeak && this.option.enableContinuousNumberCheck) {
                isWeak = this.PATTERN_CONTINUOUS_NUMBER_ASC.matcher(password).find();
            }
            if (!isWeak && this.option.enableContinuousNumberCheck) {
                isWeak = this.PATTERN_CONTINUOUS_NUMBER_DESC.matcher(password).find();
            }
            if (!isWeak && this.option.enableContinuousEnglishAlphabetCheck) {
                isWeak = this.PATTERN_CONTINUOUS_ENGLISH_ALPHABET_ASC.matcher(password).find();
            }
            if (!isWeak && this.option.enableContinuousEnglishAlphabetCheck) {
                isWeak = this.PATTERN_CONTINUOUS_ENGLISH_ALPHABET_DESC.matcher(password).find();
            }
            if (!isWeak && this.option.enableKeyboardContinuousCharCheck) {
                isWeak = this.PATTERN_KEYBOARD_HORIZONTAL_CONTINUOUS_CHARS.matcher(password).find();
            }
            if (!isWeak && this.option.enableKeyboardContinuousCharCheck) {
                isWeak = this.PATTERN_KEYBOARD_VERTICAL_CONTINUOUS_CHARS.matcher(password).find();
            }
            return isWeak;
        }
        return true;
    }

    public static class WeakPassOption {
        private int minLength;
        private int maxLength;
        int minDuplicateChars;
        int minContinuousChars;
        private boolean containSpecialCharacters;
        private boolean containSpecialNumbers;
        private boolean containSpecialUppercaseLetter;
        private boolean enableDuplicateCheck;
        private boolean enableContinuousNumberCheck;
        private boolean enableContinuousEnglishAlphabetCheck;
        private boolean enableKeyboardContinuousCharCheck;

        @Generated
        private static int $default$minLength() {
            return 6;
        }

        @Generated
        private static int $default$maxLength() {
            return 16;
        }

        @Generated
        private static int $default$minDuplicateChars() {
            return 3;
        }

        @Generated
        private static int $default$minContinuousChars() {
            return 3;
        }

        @Generated
        private static boolean $default$containSpecialCharacters() {
            return true;
        }

        @Generated
        private static boolean $default$containSpecialNumbers() {
            return true;
        }

        @Generated
        private static boolean $default$containSpecialUppercaseLetter() {
            return true;
        }

        @Generated
        private static boolean $default$enableDuplicateCheck() {
            return true;
        }

        @Generated
        private static boolean $default$enableContinuousNumberCheck() {
            return true;
        }

        @Generated
        private static boolean $default$enableContinuousEnglishAlphabetCheck() {
            return true;
        }

        @Generated
        private static boolean $default$enableKeyboardContinuousCharCheck() {
            return true;
        }

        @Generated
        WeakPassOption(int minLength, int maxLength, int minDuplicateChars, int minContinuousChars, boolean containSpecialCharacters, boolean containSpecialNumbers, boolean containSpecialUppercaseLetter, boolean enableDuplicateCheck, boolean enableContinuousNumberCheck, boolean enableContinuousEnglishAlphabetCheck, boolean enableKeyboardContinuousCharCheck) {
            this.minLength = minLength;
            this.maxLength = maxLength;
            this.minDuplicateChars = minDuplicateChars;
            this.minContinuousChars = minContinuousChars;
            this.containSpecialCharacters = containSpecialCharacters;
            this.containSpecialNumbers = containSpecialNumbers;
            this.containSpecialUppercaseLetter = containSpecialUppercaseLetter;
            this.enableDuplicateCheck = enableDuplicateCheck;
            this.enableContinuousNumberCheck = enableContinuousNumberCheck;
            this.enableContinuousEnglishAlphabetCheck = enableContinuousEnglishAlphabetCheck;
            this.enableKeyboardContinuousCharCheck = enableKeyboardContinuousCharCheck;
        }

        @Generated
        public static WeakPassOptionBuilder builder() {
            return new WeakPassOptionBuilder();
        }

        @Generated
        public int getMinLength() {
            return this.minLength;
        }

        @Generated
        public int getMaxLength() {
            return this.maxLength;
        }

        @Generated
        public int getMinDuplicateChars() {
            return this.minDuplicateChars;
        }

        @Generated
        public int getMinContinuousChars() {
            return this.minContinuousChars;
        }

        @Generated
        public boolean isContainSpecialCharacters() {
            return this.containSpecialCharacters;
        }

        @Generated
        public boolean isContainSpecialNumbers() {
            return this.containSpecialNumbers;
        }

        @Generated
        public boolean isContainSpecialUppercaseLetter() {
            return this.containSpecialUppercaseLetter;
        }

        @Generated
        public boolean isEnableDuplicateCheck() {
            return this.enableDuplicateCheck;
        }

        @Generated
        public boolean isEnableContinuousNumberCheck() {
            return this.enableContinuousNumberCheck;
        }

        @Generated
        public boolean isEnableContinuousEnglishAlphabetCheck() {
            return this.enableContinuousEnglishAlphabetCheck;
        }

        @Generated
        public boolean isEnableKeyboardContinuousCharCheck() {
            return this.enableKeyboardContinuousCharCheck;
        }

        @Generated
        public void setMinLength(int minLength) {
            this.minLength = minLength;
        }

        @Generated
        public void setMaxLength(int maxLength) {
            this.maxLength = maxLength;
        }

        @Generated
        public void setMinDuplicateChars(int minDuplicateChars) {
            this.minDuplicateChars = minDuplicateChars;
        }

        @Generated
        public void setMinContinuousChars(int minContinuousChars) {
            this.minContinuousChars = minContinuousChars;
        }

        @Generated
        public void setContainSpecialCharacters(boolean containSpecialCharacters) {
            this.containSpecialCharacters = containSpecialCharacters;
        }

        @Generated
        public void setContainSpecialNumbers(boolean containSpecialNumbers) {
            this.containSpecialNumbers = containSpecialNumbers;
        }

        @Generated
        public void setContainSpecialUppercaseLetter(boolean containSpecialUppercaseLetter) {
            this.containSpecialUppercaseLetter = containSpecialUppercaseLetter;
        }

        @Generated
        public void setEnableDuplicateCheck(boolean enableDuplicateCheck) {
            this.enableDuplicateCheck = enableDuplicateCheck;
        }

        @Generated
        public void setEnableContinuousNumberCheck(boolean enableContinuousNumberCheck) {
            this.enableContinuousNumberCheck = enableContinuousNumberCheck;
        }

        @Generated
        public void setEnableContinuousEnglishAlphabetCheck(boolean enableContinuousEnglishAlphabetCheck) {
            this.enableContinuousEnglishAlphabetCheck = enableContinuousEnglishAlphabetCheck;
        }

        @Generated
        public void setEnableKeyboardContinuousCharCheck(boolean enableKeyboardContinuousCharCheck) {
            this.enableKeyboardContinuousCharCheck = enableKeyboardContinuousCharCheck;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WeakPassOption)) {
                return false;
            }
            WeakPassOption other = (WeakPassOption)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getMinLength() != other.getMinLength()) {
                return false;
            }
            if (this.getMaxLength() != other.getMaxLength()) {
                return false;
            }
            if (this.getMinDuplicateChars() != other.getMinDuplicateChars()) {
                return false;
            }
            if (this.getMinContinuousChars() != other.getMinContinuousChars()) {
                return false;
            }
            if (this.isContainSpecialCharacters() != other.isContainSpecialCharacters()) {
                return false;
            }
            if (this.isContainSpecialNumbers() != other.isContainSpecialNumbers()) {
                return false;
            }
            if (this.isContainSpecialUppercaseLetter() != other.isContainSpecialUppercaseLetter()) {
                return false;
            }
            if (this.isEnableDuplicateCheck() != other.isEnableDuplicateCheck()) {
                return false;
            }
            if (this.isEnableContinuousNumberCheck() != other.isEnableContinuousNumberCheck()) {
                return false;
            }
            if (this.isEnableContinuousEnglishAlphabetCheck() != other.isEnableContinuousEnglishAlphabetCheck()) {
                return false;
            }
            return this.isEnableKeyboardContinuousCharCheck() == other.isEnableKeyboardContinuousCharCheck();
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof WeakPassOption;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getMinLength();
            result = result * 59 + this.getMaxLength();
            result = result * 59 + this.getMinDuplicateChars();
            result = result * 59 + this.getMinContinuousChars();
            result = result * 59 + (this.isContainSpecialCharacters() ? 79 : 97);
            result = result * 59 + (this.isContainSpecialNumbers() ? 79 : 97);
            result = result * 59 + (this.isContainSpecialUppercaseLetter() ? 79 : 97);
            result = result * 59 + (this.isEnableDuplicateCheck() ? 79 : 97);
            result = result * 59 + (this.isEnableContinuousNumberCheck() ? 79 : 97);
            result = result * 59 + (this.isEnableContinuousEnglishAlphabetCheck() ? 79 : 97);
            result = result * 59 + (this.isEnableKeyboardContinuousCharCheck() ? 79 : 97);
            return result;
        }

        @Generated
        public String toString() {
            return "WeakPasswordChecker.WeakPassOption(minLength=" + this.getMinLength() + ", maxLength=" + this.getMaxLength() + ", minDuplicateChars=" + this.getMinDuplicateChars() + ", minContinuousChars=" + this.getMinContinuousChars() + ", containSpecialCharacters=" + this.isContainSpecialCharacters() + ", containSpecialNumbers=" + this.isContainSpecialNumbers() + ", containSpecialUppercaseLetter=" + this.isContainSpecialUppercaseLetter() + ", enableDuplicateCheck=" + this.isEnableDuplicateCheck() + ", enableContinuousNumberCheck=" + this.isEnableContinuousNumberCheck() + ", enableContinuousEnglishAlphabetCheck=" + this.isEnableContinuousEnglishAlphabetCheck() + ", enableKeyboardContinuousCharCheck=" + this.isEnableKeyboardContinuousCharCheck() + ")";
        }

        @Generated
        public static class WeakPassOptionBuilder {
            @Generated
            private boolean minLength$set;
            @Generated
            private int minLength$value;
            @Generated
            private boolean maxLength$set;
            @Generated
            private int maxLength$value;
            @Generated
            private boolean minDuplicateChars$set;
            @Generated
            private int minDuplicateChars$value;
            @Generated
            private boolean minContinuousChars$set;
            @Generated
            private int minContinuousChars$value;
            @Generated
            private boolean containSpecialCharacters$set;
            @Generated
            private boolean containSpecialCharacters$value;
            @Generated
            private boolean containSpecialNumbers$set;
            @Generated
            private boolean containSpecialNumbers$value;
            @Generated
            private boolean containSpecialUppercaseLetter$set;
            @Generated
            private boolean containSpecialUppercaseLetter$value;
            @Generated
            private boolean enableDuplicateCheck$set;
            @Generated
            private boolean enableDuplicateCheck$value;
            @Generated
            private boolean enableContinuousNumberCheck$set;
            @Generated
            private boolean enableContinuousNumberCheck$value;
            @Generated
            private boolean enableContinuousEnglishAlphabetCheck$set;
            @Generated
            private boolean enableContinuousEnglishAlphabetCheck$value;
            @Generated
            private boolean enableKeyboardContinuousCharCheck$set;
            @Generated
            private boolean enableKeyboardContinuousCharCheck$value;

            @Generated
            WeakPassOptionBuilder() {
            }

            @Generated
            public WeakPassOptionBuilder minLength(int minLength) {
                this.minLength$value = minLength;
                this.minLength$set = true;
                return this;
            }

            @Generated
            public WeakPassOptionBuilder maxLength(int maxLength) {
                this.maxLength$value = maxLength;
                this.maxLength$set = true;
                return this;
            }

            @Generated
            public WeakPassOptionBuilder minDuplicateChars(int minDuplicateChars) {
                this.minDuplicateChars$value = minDuplicateChars;
                this.minDuplicateChars$set = true;
                return this;
            }

            @Generated
            public WeakPassOptionBuilder minContinuousChars(int minContinuousChars) {
                this.minContinuousChars$value = minContinuousChars;
                this.minContinuousChars$set = true;
                return this;
            }

            @Generated
            public WeakPassOptionBuilder containSpecialCharacters(boolean containSpecialCharacters) {
                this.containSpecialCharacters$value = containSpecialCharacters;
                this.containSpecialCharacters$set = true;
                return this;
            }

            @Generated
            public WeakPassOptionBuilder containSpecialNumbers(boolean containSpecialNumbers) {
                this.containSpecialNumbers$value = containSpecialNumbers;
                this.containSpecialNumbers$set = true;
                return this;
            }

            @Generated
            public WeakPassOptionBuilder containSpecialUppercaseLetter(boolean containSpecialUppercaseLetter) {
                this.containSpecialUppercaseLetter$value = containSpecialUppercaseLetter;
                this.containSpecialUppercaseLetter$set = true;
                return this;
            }

            @Generated
            public WeakPassOptionBuilder enableDuplicateCheck(boolean enableDuplicateCheck) {
                this.enableDuplicateCheck$value = enableDuplicateCheck;
                this.enableDuplicateCheck$set = true;
                return this;
            }

            @Generated
            public WeakPassOptionBuilder enableContinuousNumberCheck(boolean enableContinuousNumberCheck) {
                this.enableContinuousNumberCheck$value = enableContinuousNumberCheck;
                this.enableContinuousNumberCheck$set = true;
                return this;
            }

            @Generated
            public WeakPassOptionBuilder enableContinuousEnglishAlphabetCheck(boolean enableContinuousEnglishAlphabetCheck) {
                this.enableContinuousEnglishAlphabetCheck$value = enableContinuousEnglishAlphabetCheck;
                this.enableContinuousEnglishAlphabetCheck$set = true;
                return this;
            }

            @Generated
            public WeakPassOptionBuilder enableKeyboardContinuousCharCheck(boolean enableKeyboardContinuousCharCheck) {
                this.enableKeyboardContinuousCharCheck$value = enableKeyboardContinuousCharCheck;
                this.enableKeyboardContinuousCharCheck$set = true;
                return this;
            }

            @Generated
            public WeakPassOption build() {
                int minLength$value = this.minLength$value;
                if (!this.minLength$set) {
                    minLength$value = WeakPassOption.$default$minLength();
                }
                int maxLength$value = this.maxLength$value;
                if (!this.maxLength$set) {
                    maxLength$value = WeakPassOption.$default$maxLength();
                }
                int minDuplicateChars$value = this.minDuplicateChars$value;
                if (!this.minDuplicateChars$set) {
                    minDuplicateChars$value = WeakPassOption.$default$minDuplicateChars();
                }
                int minContinuousChars$value = this.minContinuousChars$value;
                if (!this.minContinuousChars$set) {
                    minContinuousChars$value = WeakPassOption.$default$minContinuousChars();
                }
                boolean containSpecialCharacters$value = this.containSpecialCharacters$value;
                if (!this.containSpecialCharacters$set) {
                    containSpecialCharacters$value = WeakPassOption.$default$containSpecialCharacters();
                }
                boolean containSpecialNumbers$value = this.containSpecialNumbers$value;
                if (!this.containSpecialNumbers$set) {
                    containSpecialNumbers$value = WeakPassOption.$default$containSpecialNumbers();
                }
                boolean containSpecialUppercaseLetter$value = this.containSpecialUppercaseLetter$value;
                if (!this.containSpecialUppercaseLetter$set) {
                    containSpecialUppercaseLetter$value = WeakPassOption.$default$containSpecialUppercaseLetter();
                }
                boolean enableDuplicateCheck$value = this.enableDuplicateCheck$value;
                if (!this.enableDuplicateCheck$set) {
                    enableDuplicateCheck$value = WeakPassOption.$default$enableDuplicateCheck();
                }
                boolean enableContinuousNumberCheck$value = this.enableContinuousNumberCheck$value;
                if (!this.enableContinuousNumberCheck$set) {
                    enableContinuousNumberCheck$value = WeakPassOption.$default$enableContinuousNumberCheck();
                }
                boolean enableContinuousEnglishAlphabetCheck$value = this.enableContinuousEnglishAlphabetCheck$value;
                if (!this.enableContinuousEnglishAlphabetCheck$set) {
                    enableContinuousEnglishAlphabetCheck$value = WeakPassOption.$default$enableContinuousEnglishAlphabetCheck();
                }
                boolean enableKeyboardContinuousCharCheck$value = this.enableKeyboardContinuousCharCheck$value;
                if (!this.enableKeyboardContinuousCharCheck$set) {
                    enableKeyboardContinuousCharCheck$value = WeakPassOption.$default$enableKeyboardContinuousCharCheck();
                }
                return new WeakPassOption(minLength$value, maxLength$value, minDuplicateChars$value, minContinuousChars$value, containSpecialCharacters$value, containSpecialNumbers$value, containSpecialUppercaseLetter$value, enableDuplicateCheck$value, enableContinuousNumberCheck$value, enableContinuousEnglishAlphabetCheck$value, enableKeyboardContinuousCharCheck$value);
            }

            @Generated
            public String toString() {
                return "WeakPasswordChecker.WeakPassOption.WeakPassOptionBuilder(minLength$value=" + this.minLength$value + ", maxLength$value=" + this.maxLength$value + ", minDuplicateChars$value=" + this.minDuplicateChars$value + ", minContinuousChars$value=" + this.minContinuousChars$value + ", containSpecialCharacters$value=" + this.containSpecialCharacters$value + ", containSpecialNumbers$value=" + this.containSpecialNumbers$value + ", containSpecialUppercaseLetter$value=" + this.containSpecialUppercaseLetter$value + ", enableDuplicateCheck$value=" + this.enableDuplicateCheck$value + ", enableContinuousNumberCheck$value=" + this.enableContinuousNumberCheck$value + ", enableContinuousEnglishAlphabetCheck$value=" + this.enableContinuousEnglishAlphabetCheck$value + ", enableKeyboardContinuousCharCheck$value=" + this.enableKeyboardContinuousCharCheck$value + ")";
            }
        }
    }
}

