/*
 * Decompiled with CFR 0.152.
 */
package io.github.kylinhunter.commons.uid;

import io.github.kylinhunter.commons.exception.embed.GeneralException;
import io.github.kylinhunter.commons.exception.embed.ParamException;
import io.github.kylinhunter.commons.uid.UidInfo;
import lombok.Generated;

public class UidGenerator {
    private static final long INIT_EPOCH = 1632499200000L;
    private long sequence;
    private long type;
    private long workerId;
    private long datacenterId;
    private long lastTimestamp = -1L;
    private final int TYPE_SHIFT;
    private final int WORKER_ID_SHIFT;
    private final int DATA_CENTER_ID_SHIFT;
    private final int TIMESTAMP_SHIFT;
    private final long SEQUENCE_MAX;
    private final long TYPE_MAX;
    private final int WORKER_ID_MAX;
    private final int DATA_CENTER_ID_MAX;
    private final long TIMESTAMP_MAX;

    public UidGenerator(long type, long workerId, long datacenterId) {
        this(12, 4, 4, 2, type, workerId, datacenterId);
    }

    public UidGenerator(int sequenceBits, int typeBits, int workerIdBits, int datacenterIdBits, long type, long workerId, long datacenterId) {
        if (sequenceBits < 10 || sequenceBits > 16) {
            throw new GeneralException("sequenceBits must between [5-20]");
        }
        if (typeBits < 1 || typeBits > 8) {
            throw new GeneralException("typeBits must between [2-5]");
        }
        if (workerIdBits < 2 || workerIdBits > 8) {
            throw new GeneralException("workerIdBits must between [2-5]");
        }
        if (datacenterIdBits < 1 || datacenterIdBits > 5) {
            throw new GeneralException("datacenterIdBits must between [2-5]");
        }
        int bits = workerIdBits + datacenterIdBits + sequenceBits;
        if (bits < 18 || bits > 26) {
            throw new GeneralException("workerIdBits + datacenterIdBits + sequenceBits between [18-26]");
        }
        this.SEQUENCE_MAX = -1L << sequenceBits ^ 0xFFFFFFFFFFFFFFFFL;
        this.TYPE_MAX = ~(-1 << typeBits);
        this.WORKER_ID_MAX = ~(-1 << workerIdBits);
        this.DATA_CENTER_ID_MAX = ~(-1 << datacenterIdBits);
        this.TYPE_SHIFT = sequenceBits;
        this.WORKER_ID_SHIFT = sequenceBits + typeBits;
        this.DATA_CENTER_ID_SHIFT = sequenceBits + typeBits + workerIdBits;
        this.TIMESTAMP_SHIFT = sequenceBits + typeBits + workerIdBits + datacenterIdBits;
        long timestampBits = 63 - sequenceBits - typeBits - workerIdBits - datacenterIdBits;
        this.TIMESTAMP_MAX = -1L << (int)timestampBits ^ 0xFFFFFFFFFFFFFFFFL;
        if (type > this.TYPE_MAX || type < 0L) {
            throw new ParamException("type Id can't less than 0 or great than " + this.TYPE_MAX);
        }
        if (workerId > (long)this.WORKER_ID_MAX || workerId < 0L) {
            throw new ParamException("worker Id can't less than 0 or great than " + this.WORKER_ID_MAX);
        }
        if (datacenterId > (long)this.DATA_CENTER_ID_MAX || datacenterId < 0L) {
            throw new ParamException("datacenterId Id can't less than 0 or great than " + this.DATA_CENTER_ID_MAX);
        }
        this.type = type;
        this.workerId = workerId;
        this.datacenterId = datacenterId;
    }

    public synchronized long nextId() {
        long timestamp = System.currentTimeMillis();
        if (timestamp < this.lastTimestamp) {
            throw new GeneralException("clock is moving backwards.  Rejecting requests until " + this.lastTimestamp);
        }
        if (this.lastTimestamp == timestamp) {
            this.sequence = this.sequence + 1L & this.SEQUENCE_MAX;
            if (this.sequence == 0L) {
                timestamp = this.nextMillis(this.lastTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTimestamp = timestamp;
        return timestamp - 1632499200000L << this.TIMESTAMP_SHIFT | this.datacenterId << this.DATA_CENTER_ID_SHIFT | this.workerId << this.WORKER_ID_SHIFT | this.type << this.TYPE_SHIFT | this.sequence;
    }

    private long nextMillis(long lastTimestamp) {
        long timestamp = System.currentTimeMillis();
        while (timestamp <= lastTimestamp) {
            timestamp = System.currentTimeMillis();
        }
        return timestamp;
    }

    public UidInfo parse(long uid) {
        long sequence = uid & this.SEQUENCE_MAX;
        long type = uid >> this.TYPE_SHIFT & this.TYPE_MAX;
        long workerId = uid >> this.WORKER_ID_SHIFT & (long)this.WORKER_ID_MAX;
        long datacenterId = uid >> this.DATA_CENTER_ID_SHIFT & (long)this.DATA_CENTER_ID_MAX;
        long timestamp = (uid >> this.TIMESTAMP_SHIFT & this.TIMESTAMP_MAX) + 1632499200000L;
        return new UidInfo(sequence, type, workerId, datacenterId, timestamp);
    }

    @Generated
    public long getSequence() {
        return this.sequence;
    }

    @Generated
    public long getType() {
        return this.type;
    }

    @Generated
    public void setType(long type) {
        this.type = type;
    }

    @Generated
    public long getWorkerId() {
        return this.workerId;
    }

    @Generated
    public void setWorkerId(long workerId) {
        this.workerId = workerId;
    }

    @Generated
    public long getDatacenterId() {
        return this.datacenterId;
    }

    @Generated
    public void setDatacenterId(long datacenterId) {
        this.datacenterId = datacenterId;
    }

    @Generated
    public long getLastTimestamp() {
        return this.lastTimestamp;
    }
}

