/*
 * Decompiled with CFR 0.152.
 */
package io.github.kylinhunter.commons.util;

import java.util.regex.Pattern;

public class HexUtils {
    private static final String HEX_STR = "0123456789ABCDEF";
    private static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();
    private static final Pattern PATTERN_HEX = Pattern.compile("^[A-Fa-f0-9]+$");

    public static String toString(byte[] bytes) {
        return HexUtils.toString(bytes, 0, bytes.length);
    }

    public static String toString(byte[] bytes, int off, int len) {
        if (HexUtils.check(bytes, off, len)) {
            return "";
        }
        char[] hexChars = new char[len * 2];
        for (int i = 0; i < len; ++i) {
            int j = off + i;
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }

    public static byte[] toBytes(String hex) {
        int len = hex.length() / 2;
        byte[] result = new byte[len];
        for (int i = 0; i < len; ++i) {
            int pos = i * 2;
            result[i] = (byte)(HexUtils.Str2Hex(hex.charAt(pos)) << 4 | HexUtils.Str2Hex(hex.charAt(pos + 1)));
        }
        return result;
    }

    static byte Str2Hex(char ch) {
        if (ch >= '0' & ch <= '9') {
            return (byte)(ch - 48);
        }
        if (ch >= 'a' & ch <= 'f') {
            return (byte)(ch - 97 + 10);
        }
        if (ch >= 'A' & ch <= 'F') {
            return (byte)(ch - 65 + 10);
        }
        return 0;
    }

    private static boolean check(byte[] bytes, int off, int len) {
        if (bytes == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > bytes.length || len < 0 || off + len > bytes.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        return len == 0;
    }

    public static boolean isHex(String str) {
        return PATTERN_HEX.matcher(str).matches();
    }
}

