/*
 * Decompiled with CFR 0.152.
 */
package io.github.kylinhunter.commons.util;

import io.github.kylinhunter.commons.collections.ListUtils;
import io.github.kylinhunter.commons.date.DateUtils;
import io.github.kylinhunter.commons.lang.BooleanUtil;
import io.github.kylinhunter.commons.lang.NumberUtil;
import io.github.kylinhunter.commons.reflect.ClassUtil;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ObjectValues {
    public static boolean getBoolean(Object obj) {
        return ObjectValues.getBoolean(obj, false);
    }

    public static boolean getBoolean(Object obj, boolean defaultValue) {
        if (obj == null) {
            return defaultValue;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        return BooleanUtil.toBoolean(obj.toString());
    }

    public static int getInt(Object obj) {
        return ObjectValues.getInt(obj, 0);
    }

    public static int getInt(Object obj, int defaultValue) {
        if (obj == null) {
            return defaultValue;
        }
        if (obj instanceof Number) {
            return ((Number)obj).intValue();
        }
        return NumberUtil.toInt(String.valueOf(obj), defaultValue);
    }

    public static long getLong(Object obj) {
        return ObjectValues.getLong(obj, 0L);
    }

    public static long getLong(Object obj, long defaultValue) {
        if (obj == null) {
            return defaultValue;
        }
        if (obj instanceof Number) {
            return ((Number)obj).longValue();
        }
        return NumberUtil.toLong(String.valueOf(obj), defaultValue);
    }

    public static double getDouble(Object obj) {
        return ObjectValues.getDouble(obj, 0.0);
    }

    public static double getDouble(Object obj, double defaultValue) {
        if (obj == null) {
            return defaultValue;
        }
        if (obj instanceof Number) {
            return ((Number)obj).doubleValue();
        }
        return NumberUtil.toDouble(String.valueOf(obj), defaultValue);
    }

    public static float getFloat(Object obj) {
        return ObjectValues.getFloat(obj, 0.0f);
    }

    public static float getFloat(Object obj, float defaultValue) {
        if (obj == null) {
            return defaultValue;
        }
        if (obj instanceof Number) {
            return ((Number)obj).floatValue();
        }
        return NumberUtil.toFloat(String.valueOf(obj), defaultValue);
    }

    public static String getString(Object obj) {
        if (obj == null) {
            return "";
        }
        return String.valueOf(obj).trim();
    }

    public static LocalDateTime getLocalDateTime(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof LocalDateTime) {
            return (LocalDateTime)obj;
        }
        if (obj instanceof String) {
            return DateUtils.parse((String)obj);
        }
        return null;
    }

    public static <T> List<T> getList(Object obj) {
        if (obj == null) {
            return Collections.emptyList();
        }
        if (obj instanceof List) {
            return (List)obj;
        }
        if (obj instanceof Collection) {
            Collection c = (Collection)obj;
            ArrayList list = ListUtils.newArrayList();
            list.addAll(c);
            return list;
        }
        return Collections.emptyList();
    }

    public static <T> T get(Object obj, Class<T> clazz) {
        if (obj != null && clazz != null) {
            Class<?> objClazz = obj.getClass();
            if (clazz.isAssignableFrom(objClazz)) {
                return (T)obj;
            }
            if (ClassUtil.isPrimitiveOrWrapper(clazz)) {
                if (clazz == Integer.TYPE || clazz == Integer.class) {
                    return (T)Integer.valueOf(NumberUtil.toInt(String.valueOf(obj)));
                }
                if (clazz == Long.TYPE || clazz == Long.class) {
                    return (T)Long.valueOf(NumberUtil.toLong(String.valueOf(obj)));
                }
                if (clazz == Float.TYPE || clazz == Float.class) {
                    return (T)Float.valueOf(NumberUtil.toFloat(String.valueOf(obj)));
                }
                if (clazz == Double.TYPE || clazz == Double.class) {
                    return (T)Double.valueOf(NumberUtil.toDouble(String.valueOf(obj)));
                }
                if (clazz == Short.TYPE || clazz == Short.class) {
                    return (T)Short.valueOf(NumberUtil.toShort(String.valueOf(obj)));
                }
                if (clazz == Boolean.TYPE || clazz == Boolean.class) {
                    return (T)Boolean.valueOf(BooleanUtil.toBoolean(String.valueOf(obj)));
                }
            } else if (clazz == String.class) {
                return (T)String.valueOf(obj);
            }
        }
        return null;
    }
}

