/*
 * Decompiled with CFR 0.152.
 */
package io.github.kylinhunter.tools.dic.words.analyzer.imp;

import io.github.kylinhunter.commons.component.C;
import io.github.kylinhunter.tools.dic.words.analyzer.AbstractWordAnalyzer;
import io.github.kylinhunter.tools.dic.words.analyzer.bean.Words;
import java.io.Closeable;
import java.io.IOException;
import org.apache.commons.io.IOUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wltea.analyzer.lucene.IKAnalyzer;

@C
public class IKWordAnalyzer
extends AbstractWordAnalyzer {
    private static final Logger log = LoggerFactory.getLogger(IKWordAnalyzer.class);
    Analyzer ik = new IKAnalyzer();
    private static final String DEFAULT_FIELD = "f";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Words analyze(String text) {
        Words words = new Words();
        TokenStream ts = this.ik.tokenStream(DEFAULT_FIELD, text);
        try {
            ts.reset();
            OffsetAttribute offset = (OffsetAttribute)ts.addAttribute(OffsetAttribute.class);
            while (ts.incrementToken()) {
                words.addWord(offset.toString(), offset.startOffset(), offset.endOffset());
            }
            ts.end();
        }
        catch (IOException e) {
            log.error("analyze error", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Closeable)ts);
        }
        return words;
    }
}

