/*
 * Decompiled with CFR 0.152.
 */
package io.github.kylinhunter.tools.dic.words.pinyin;

import com.google.common.collect.Lists;
import io.github.kylinhunter.tools.dic.words.pinyin.PinyinService;
import java.util.ArrayList;
import java.util.Arrays;
import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPinyinService
implements PinyinService {
    private static final Logger log = LoggerFactory.getLogger(AbstractPinyinService.class);
    protected HanyuPinyinOutputFormat format = new HanyuPinyinOutputFormat();
    protected static String[] EMPTY = new String[0];

    @Override
    public String toPinyin(char c) {
        String[] pinyin = this.toPinyins(c);
        if (pinyin != null && pinyin.length > 0) {
            return pinyin[0];
        }
        return null;
    }

    @Override
    public String toPinyin(String pinYinStr) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < pinYinStr.length(); ++i) {
            String tempStr = this.toPinyin(pinYinStr.charAt(i));
            if (tempStr == null) {
                sb.append(pinYinStr.charAt(i));
                continue;
            }
            sb.append(tempStr);
        }
        return sb.toString();
    }

    @Override
    public String[] toPinyins(char c) {
        try {
            String[] pinyin = PinyinHelper.toHanyuPinyinStringArray((char)c, (HanyuPinyinOutputFormat)this.format);
            if (pinyin != null && pinyin.length > 0) {
                return pinyin;
            }
            return EMPTY;
        }
        catch (Exception e) {
            log.error("get pinyin error", (Throwable)e);
            return EMPTY;
        }
    }

    @Override
    public String[] toPinyins(String oriStr, int maxSize) {
        ArrayList allPinyins = Lists.newArrayList();
        allPinyins.add(new String[oriStr.length()]);
        for (int curChar = 0; curChar < oriStr.length(); ++curChar) {
            String[] curCharPinyins = this.toPinyins(oriStr.charAt(curChar));
            if (curCharPinyins == null || curCharPinyins.length <= 0) {
                if (allPinyins.size() == 1) {
                    ((String[])allPinyins.get((int)0))[curChar] = oriStr.substring(curChar, curChar + 1);
                    continue;
                }
                String tmp = oriStr.substring(curChar, curChar + 1);
                for (String[] charPinyin : allPinyins) {
                    charPinyin[curChar] = tmp;
                }
                continue;
            }
            if (curCharPinyins.length == 1) {
                if (allPinyins.size() == 1) {
                    ((String[])allPinyins.get((int)0))[curChar] = curCharPinyins[0];
                    continue;
                }
                for (String[] charPinyin : allPinyins) {
                    charPinyin[curChar] = curCharPinyins[0];
                }
                continue;
            }
            if (allPinyins.size() == 1) {
                for (int j = 0; j < curCharPinyins.length; ++j) {
                    if (j == 0) {
                        ((String[])allPinyins.get((int)0))[curChar] = curCharPinyins[0];
                        continue;
                    }
                    if (curCharPinyins[j].equals(curCharPinyins[j - 1]) || maxSize > 0 && allPinyins.size() >= maxSize) continue;
                    String[] newCopy = Arrays.copyOf((String[])allPinyins.get(0), ((String[])allPinyins.get(0)).length);
                    newCopy[curChar] = curCharPinyins[j];
                    allPinyins.add(newCopy);
                }
                continue;
            }
            int curLen = allPinyins.size();
            for (int j = 0; j < curCharPinyins.length; ++j) {
                if (j == 0) {
                    for (String[] charPinyin : allPinyins) {
                        charPinyin[curChar] = curCharPinyins[j];
                    }
                    continue;
                }
                if (curCharPinyins[j].equals(curCharPinyins[j - 1])) continue;
                for (int k = 0; k < curLen; ++k) {
                    if (maxSize > 0 && allPinyins.size() >= maxSize) continue;
                    String[] newCopy = Arrays.copyOf((String[])allPinyins.get(k), ((String[])allPinyins.get(k)).length);
                    newCopy[curChar] = curCharPinyins[j];
                    allPinyins.add(newCopy);
                }
            }
        }
        if (allPinyins.size() == 1) {
            return new String[]{StringUtils.join((Object[])((String[])allPinyins.get(0)))};
        }
        return (String[])allPinyins.stream().map(StringUtils::join).toArray(String[]::new);
    }
}

