/*
 * Decompiled with CFR 0.152.
 */
package io.github.lcaohoanq;

import io.github.lcaohoanq.SharedRes;
import java.awt.Desktop;
import java.net.URI;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0001H\u0007J\u001a\u0010\u0007\u001a\u00020\u00052\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u0001H\u0007\u00a8\u0006\n"}, d2={"Lio/github/lcaohoanq/BrowserLauncher;", "", "<init>", "()V", "openHomePage", "", "urls", "doHealthCheckThenOpenHomePage", "healthCheckEndpoint", "", "brlc"})
@SourceDebugExtension(value={"SMAP\nBrowserLauncher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BrowserLauncher.kt\nio/github/lcaohoanq/BrowserLauncher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,110:1\n808#2,11:111\n*S KotlinDebug\n*F\n+ 1 BrowserLauncher.kt\nio/github/lcaohoanq/BrowserLauncher\n*L\n45#1:111,11\n*E\n"})
public final class BrowserLauncher {
    @NotNull
    public static final BrowserLauncher INSTANCE = new BrowserLauncher();

    private BrowserLauncher() {
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void openHomePage(@NotNull Object urls) {
        Intrinsics.checkNotNullParameter((Object)urls, (String)"urls");
        try {
            List list;
            Object object = urls;
            if (object instanceof List) {
                void $this$filterIsInstanceTo$iv$iv;
                Iterable $this$filterIsInstance$iv = (Iterable)urls;
                boolean $i$f$filterIsInstance = false;
                Iterable iterable = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof String)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list = (List)destination$iv$iv;
            } else if (object instanceof String) {
                list = CollectionsKt.listOf((Object)urls);
            } else {
                throw new IllegalArgumentException("Invalid argument type. Expected String or List<String>");
            }
            List urlList = list;
            Desktop desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
            String string = System.getProperty("os.name");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
            String string2 = string;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string3 = string2.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
            String os = string3;
            for (String url : urlList) {
                String[] stringArray;
                Object object2;
                if (desktop != null && desktop.isSupported(Desktop.Action.BROWSE)) {
                    desktop.browse(URI.create(url));
                    object2 = Unit.INSTANCE;
                    continue;
                }
                if (StringsKt.contains$default((CharSequence)os, (CharSequence)"win", (boolean)false, (int)2, null)) {
                    stringArray = new String[]{"rundll32", "url.dll,FileProtocolHandler", url};
                    object2 = new ProcessBuilder(stringArray).start();
                    continue;
                }
                if (StringsKt.contains$default((CharSequence)os, (CharSequence)"mac", (boolean)false, (int)2, null)) {
                    stringArray = new String[]{"open", url};
                    object2 = new ProcessBuilder(stringArray).start();
                    continue;
                }
                if (StringsKt.contains$default((CharSequence)os, (CharSequence)"nix", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)os, (CharSequence)"nux", (boolean)false, (int)2, null)) {
                    stringArray = new String[]{"xdg-open", url};
                    object2 = new ProcessBuilder(stringArray).start();
                    continue;
                }
                System.out.println((Object)("Unsupported operating system: " + os));
                object2 = Unit.INSTANCE;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @JvmStatic
    public static final void doHealthCheckThenOpenHomePage(@Nullable String healthCheckEndpoint, @NotNull Object urls) {
        Intrinsics.checkNotNullParameter((Object)urls, (String)"urls");
        try {
            HttpRequest request;
            HttpResponse<String> response;
            CharSequence charSequence = healthCheckEndpoint;
            if (charSequence == null || charSequence.length() == 0) {
                System.out.println((Object)"Health check endpoint is null or empty. Skipping health check.");
                BrowserLauncher.openHomePage(urls);
                return;
            }
            String string = System.getProperty("server.hostname");
            if (string == null) {
                string = "localhost";
            }
            String hostname = string;
            Object object = System.getProperty("server.port");
            int port = object != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : 8080;
            HttpRequest.Builder builder = HttpRequest.newBuilder();
            String string2 = healthCheckEndpoint;
            if (string2 == null) {
                string2 = "http://" + hostname + ':' + port + "/actuator/health";
            }
            if ((response = SharedRes.HTTP_CLIENT.send(request = builder.uri(URI.create(string2)).timeout(Duration.ofSeconds(5L)).GET().build(), HttpResponse.BodyHandlers.ofString())).statusCode() == 200) {
                System.out.println((Object)"Health check passed. Opening home page...");
                BrowserLauncher.openHomePage(urls);
            } else {
                System.out.println((Object)("Health check failed with status code: " + response.statusCode()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

