/*
 * Decompiled with CFR 0.152.
 */
package io.github.lcaohoanq;

import io.github.lcaohoanq.BrowserLauncher;
import io.github.lcaohoanq.SharedRes;
import java.net.URI;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;

public class JavaBrowserLauncher {
    public static void openHomePage(Object urls) {
        BrowserLauncher.openHomePage(urls);
    }

    public static void doHealthCheckThenOpenHomePage(String healthCheckEndpoint, Object urls) {
        if (healthCheckEndpoint == null || healthCheckEndpoint.isEmpty()) {
            System.out.println("Health check endpoint is null or empty. Skipping health check.");
            JavaBrowserLauncher.openHomePage(urls);
            return;
        }
        try {
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(healthCheckEndpoint)).timeout(Duration.ofSeconds(5L)).GET().build();
            HttpResponse<String> response = SharedRes.HTTP_CLIENT.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() == 200) {
                System.out.println("Health check passed. Opening home page...");
                JavaBrowserLauncher.openHomePage(urls);
            } else {
                System.out.println("Health check failed with status code: " + response.statusCode());
            }
        }
        catch (Exception e) {
            System.err.println("Health check failed with exception: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public static CompletableFuture<Void> doHealthCheckThenOpenHomePageAsync(String healthCheckEndpoint, Object urls) {
        if (healthCheckEndpoint == null || healthCheckEndpoint.isEmpty()) {
            System.out.println("Health check endpoint is null or empty. Skipping health check.");
            JavaBrowserLauncher.openHomePage(urls);
            return CompletableFuture.completedFuture(null);
        }
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(healthCheckEndpoint)).timeout(Duration.ofSeconds(5L)).GET().build();
        return ((CompletableFuture)SharedRes.HTTP_CLIENT.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenAccept(response -> {
            if (response.statusCode() == 200) {
                System.out.println("Health check passed. Opening home page...");
                JavaBrowserLauncher.openHomePage(urls);
            } else {
                System.out.println("Health check failed with status code: " + response.statusCode());
            }
        })).exceptionally(e -> {
            System.err.println("Health check failed with exception: " + e.getMessage());
            e.printStackTrace();
            return null;
        });
    }
}

